<?php 
	/*	
	*	Goodlayers Getting Start Page
	*	---------------------------------------------------------------------
	*	This file that creates getting start page
	*	---------------------------------------------------------------------
	*/	

	if( class_exists('gdlr_core_getting_start') ){
		new gdlr_core_getting_start(array(
			'parent-slug' => 'goodlayers_main_menu',
			'page-title' => esc_html__('Getting Start / Import', 'seocrawler'),
			'menu-title' => esc_html__('Getting Start / Import', 'seocrawler'),
			'capability' => 'edit_theme_options'
		));
	}

	add_filter('gdlr_core_getting_start_option', 'seocrawler_gdlr_core_getting_start_option', 10, 2);
	if( !function_exists('seocrawler_gdlr_core_getting_start_option') ){
		function seocrawler_gdlr_core_getting_start_option( $options, $slug ){
			if( $slug == 'gdlr_core_getting_start' ){

				$content = array();

				// install plugins link
				$plugins_complete = seocrawler_tgmpa_complete();
				if( !$plugins_complete ){
					$content['required-plugins'] = array(
						'title' => esc_html__('Required Plugins', 'seocrawler'),
						'type' => 'page',
						'content' => '<p>' . wp_kses(__('<strong>Before moving on, please make sure that all required plugins are installed and activated</strong><br>This is very important step to make the theme run properly.', 'seocrawler'), array('strong'=>array(), 'br'=>array()) ) . 
							'</p><a class="gdlr-core-button" href="' . esc_attr(admin_url('themes.php?page=tgmpa-install-plugins')) . '" >' . esc_html__('Install Required Plugins', 'seocrawler') . '</a>' .
							'<h3>' . esc_html__('1. Install plugins then click on \'Return To Require Plugins Installer', 'seocrawler') . '</h3><img src="' . esc_url(get_template_directory_uri() . '/images/getting-start/require-plugin1.jpg') . '" alt="" />' .
							'<h3>' . esc_html__('2. Activate plugins', 'seocrawler') . '</h3><img src="' . esc_url(get_template_directory_uri() . '/images/getting-start/require-plugin2.jpg') . '" alt="" />'
					);
				}

				// guidelines
				$content['guidelines'] = array(
					'title' => esc_html__('Guidelines', 'seocrawler'),
					'type' => 'page',
					'content' => 
						wp_kses(__('<h4>1.) Installation</h4>', 'seocrawler'), array('h4'=>array())) . '<iframe width="560" height="315" src="https://www.youtube.com/embed/8FFYrwe8P-M" frameborder="0" allowfullscreen></iframe>' .
						wp_kses(__('<h4>2.) Importing Demo</h4>', 'seocrawler'), array('h4'=>array())) . '<iframe width="560" height="315" src="https://www.youtube.com/embed/wiRutAm2Kkc" frameborder="0" allowfullscreen></iframe>' .
						wp_kses(__('<h4>3.) Creating Portfolio</h4>', 'seocrawler'), array('h4'=>array())) . '<iframe width="560" height="315" src="https://www.youtube.com/embed/XFrtHJuPW_4" frameborder="0" allowfullscreen></iframe>' . 
						wp_kses(__('<h4>4.) Creating Personnel</h4>', 'seocrawler'), array('h4'=>array())) . '<iframe width="560" height="315" src="https://www.youtube.com/embed/MwFxxSlYuAA" frameborder="0" allowfullscreen></iframe>' . 
						wp_kses(__('<h4>5.) Creating Blog</h4>', 'seocrawler'), array('h4'=>array())) . '<iframe width="560" height="315" src="https://www.youtube.com/embed/fqcdMzTjvrE" frameborder="0" allowfullscreen></iframe>' .
						wp_kses(__('<h4>6.) Goodlayers Page Builder</h4>', 'seocrawler'), array('h4'=>array())) . '<iframe width="560" height="315" src="https://www.youtube.com/embed/N0haJbDM8ac" frameborder="0" allowfullscreen></iframe>'
				);

				// import demo
				$content['import-demo'] = array(
					'title' => esc_html__('Import Demo', 'seocrawler'),
					'type' => 'demo',
					'content' => wp_kses(__('<strong>Get import error?</strong> Please make sure that your server has PHP max_execution_time at least 300, memory_limit at least 512MB. You may set these values temporaly and change it back after finish importing.<br><strong>If you\'re importing main demo (Full Version), PHP max_input_vars is recommended to be at least 4000</strong>', 'seocrawler'), array('strong'=>array(), 'br'=>array())),
					'demo-content' => wp_kses(
						__('<strong>Main demo (Full verion)</strong> - include all pages shown in demo such as elements, features, about us, services contact, all portfolio pages, all blog pages. It\'s 100+ pages and 170+ images in total.', 'seocrawler') . '<br><br>' . 
						__('<strong>Main demo (Lite verion)</strong> - include about us, services, few portfolios, few blog pages. Element and feature page are not included.', 'seocrawler') . '<br><br>' . 
						__('Please also be cautious that over 1000+ images will be generated in main demo.', 'seocrawler'), 
						array('strong'=>array(), 'br'=>array())),
				);

				// system status
				$content['system-status'] = array(
					'title' => esc_html__('System Status', 'seocrawler'),
					'type' => 'system-status',
					'content' => wp_kses(__('<strong>To import demo content</strong>, PHP max_execution_time at least 300 secs and  memory_limit at least 512MB is recommended. <strong><br>If you\'re importing main demo (Full Version)</strong>, PHP max_input_vars is recommended to be at least 4000.', 'seocrawler'), array('strong'=>array(), 'br'=>array()))
				);

				// obtain product validation link
				if( !empty($GLOBALS['tgmpa']) ){
					$plugin_slug = 'envato-market';
					$plugin_url = 'admin.php?page=envato-market';
					$product_validation_url = seocrawler_tgmpa_auto_install_url($plugin_slug,  $plugin_url);

					$tgmpa = call_user_func(array(get_class($GLOBALS['tgmpa']), 'get_instance'));
					if( !$tgmpa->is_plugin_installed($plugin_slug) ){
						$content['get-automatic-updates'] = array(
							'title' => esc_html__('Get Automatic Updates', 'seocrawler'),
							'type' => 'page',
							'content' => wp_kses(__('<p><strong>To get automatic updates, you need to install and activate the plugin \'Envato Market\'</strong>.<br>You\'ll also need API Personal Token for verification. Please read for instruction in plugin settings.</p>', 'seocrawler'), array('strong'=>array(), 'br'=>array(), 'p'=> array()) ) . 
								'<a class="gdlr-core-button" href="' . esc_url($product_validation_url) . '" >' . esc_html__('Get envato market plugin now!', 'seocrawler') . '</a>'
						);
					}else{
						$content['get-automatic-updates'] = array(
							'title' => esc_html__('Get Automatic Updates', 'seocrawler'),
							'type' => 'page',
							'content' => wp_kses(__('<p><strong>To get automatic updates</strong>, you need to fill the infomation in \'Envato Market\' plugin page.<br>You need to retrieve API Personal Token for verification. Please read for instruction in plugin settings.</p>', 'seocrawler'), array('strong'=>array(), 'br'=>array(), 'p'=> array()) ) . 
								'<a class="gdlr-core-button" href="' . esc_url($product_validation_url) . '" >' . esc_html__('Go to plugin settings!', 'seocrawler') . '</a>'
						);
					}
				}

				// support
				$content['support'] = array(
					'title' => esc_html__('Support', 'seocrawler'),
					'type' => 'page',
					'content' => wp_kses(__('<p><strong>Have questions about how to use the theme?</strong></p><p>Make sure that you read all through the document we provided. The document is contained in main package that you downloaded from Themeforest. It\'s in the folder \'Document-Instruction\', open the file \'index.html\' with your browser. Or you can view online document here.</p>', 'seocrawler'), array('strong'=>array(), 'br'=>array(), 'p'=> array()) ) . 
						'<a class="gdlr-core-button" target="_blank" href="#" >' . esc_html__('View Online Document', 'seocrawler') . '</a><br><br>' .
						wp_kses(__('<p><strong>Have problems or can\'t find answer in the document?</strong></p><p>1. Make sure that you are running the latest version of the theme.<br>2. Make sure that you deeply checked theme\'s instruction and try to search for public tickets in case of someone else asked the same question before. <br> 3. Try to deactivate all plugins (Except Goodlayers plugins) and see if the problem resolved or not.</p>', 'seocrawler'), array('strong'=>array(), 'br'=>array(), 'p'=> array()) ) .
						wp_kses(sprintf(__('<p>After doing these steps and still see the problem, feel free to submit tickets in our support website. Our supporter are happy to help you.<br><strong>Please note that you will need Purchase code to submit the ticket</strong> - <a href="%s" target="_blank" >How to get purchased code?</a></p>', 'seocrawler'), 'https://help.market.envato.com/hc/en-us/articles/202822600'), array('strong'=>array(), 'br'=>array(), 'p'=> array(), 'a'=>array('href'=>array(), 'target'=>array())) ) .
						'<a class="gdlr-core-button" target="_blank" href="http://support.goodlayers.com" >' . esc_html__('Go to support website', 'seocrawler') . '</a>'
				);

				return array(
					'header' => array(
						'logo' => get_template_directory_uri() . '/images/getting-start/header.png',
						'title' => esc_html__('Congratulations !', 'seocrawler'),
						'caption' => '<strong>' . esc_html__('SEO Crawler', 'seocrawler') . '</strong> ' . esc_html__('WordPress theme is now installed and ready to use. Thank you so much for choosing Goodlayers!', 'seocrawler')
					),
					'content' => $content
				);
			}

			return $options;
		}
	}

	// add filter for demo import
	add_filter('gdlr_core_demo_options', 'seocrawler_gdlr_core_demo_options');
	if( !function_exists('seocrawler_gdlr_core_demo_options') ){
		function seocrawler_gdlr_core_demo_options($demo){
			return array(
				'seocrawler' => array(
					'title' => esc_html__('SEO Crawler', 'seocrawler'),
					'url' => 'http://demo.goodlayers.com/seocrawler',
					'xml' => get_template_directory() . '/admin/function/files/seocrawler.xml',
					'page' => 2039,
					'menu' => array('main_menu' => 36, 'mobile_menu' => 36),
					'widget' => '{"gdlrcst_sidebar_name":[{"name":"Elements","id":"elements"},{"name":"Blog","id":"blog"},{"name":"Blog Left","id":"blog-left"},{"name":"Blog Right","id":"blog-right"},{"name":"Shop","id":"shop"}],"sidebars_widgets":{"wp_inactive_widgets":["nav_menu-1","nav_menu-2","text-6"],"gdlr-core-sidebar-preset":["search-2","recent-posts-2","recent-comments-2","archives-2","categories-2","meta-2"],"footer-1":["text-1"],"footer-2":["text-2"],"footer-3":["nav_menu-3"],"footer-4":["text-7","nav_menu-4"],"elements":[],"blog":["text-3","gdlr-core-recent-portfolio-widget-2","recent-comments-3","tag_cloud-1"],"blog-left":["search-3","text-4","recent-posts-4","gdlr-core-portfolio-slider-widget-1"],"blog-right":["text-5","recent-comments-4","tag_cloud-2"],"shop":["woocommerce_price_filter-2","woocommerce_widget_cart-2","woocommerce_product_categories-2"],"array_version":3},"widget_archives":{"2":{"title":"","count":0,"dropdown":0},"_multiwidget":1},"widget_calendar":{"_multiwidget":1},"widget_categories":{"2":{"title":"","count":0,"hierarchical":0,"dropdown":0},"_multiwidget":1},"widget_gdlr-core-portfolio-slider-widget":{"1":{"title":"Recent Works","category":"","num-fetch":"3","thumbnail-size":"Frame Landscape 2"},"_multiwidget":1},"widget_gdlr-core-post-slider-widget":{"_multiwidget":1},"widget_gdlr-core-recent-portfolio-widget":{"2":{"title":"Recent Works","category":"","num-fetch":"9"},"_multiwidget":1},"widget_gdlr-core-recent-post-widget":{"_multiwidget":1},"widget_gdlr-core-twitter-widget":{"_multiwidget":1},"widget_media_audio":{"_multiwidget":1},"widget_media_image":{"_multiwidget":1},"widget_media_video":{"_multiwidget":1},"widget_meta":{"2":{"title":""},"_multiwidget":1},"widget_nav_menu":{"1":{"title":"Market Sectors","nav_menu":69},"2":{"title":"Useful Links","nav_menu":70},"3":{"title":"Our Services","nav_menu":60},"4":{"nav_menu":61},"_multiwidget":1},"widget_newsletterwidget":{"_multiwidget":1},"widget_newsletterwidgetminimal":{"_multiwidget":1},"widget_pages":{"_multiwidget":1},"widget_recent-comments":{"2":{"title":"","number":5},"3":{"title":"","number":5},"4":{"title":"","number":5},"_multiwidget":1},"widget_recent-posts":{"2":{"title":"","number":5},"4":{"title":"Recent Posts","number":5,"show_date":false},"_multiwidget":1},"widget_rev-slider-widget":{"_multiwidget":1},"widget_rss":{"1":[],"_multiwidget":1},"widget_search":{"2":{"title":""},"3":{"title":""},"_multiwidget":1},"widget_tag_cloud":{"1":{"title":"Tag Cloud","taxonomy":"post_tag"},"2":{"title":"Tag Cloud","taxonomy":"post_tag"},"_multiwidget":1},"widget_text":{"1":{"title":"About Us","text":"<span style=\"font-size: 14px; color:#ababab;\">Far far away, behind the word mountains, far from the countries Vokalia and Consonantia, there live the blind texts.<\/span>\r\n\r\n[gdlr_core_space height=\"21px\"]\r\n<img src=\"http:\/\/demo.goodlayers.com\/seocrawler\/wp-content\/uploads\/2017\/06\/logo.png\" alt=\"\" \/>","filter":"content"},"2":{"title":"Contact Info","text":"[gdlr_core_icon icon=\"fa fa-location-arrow\" size=\"16px\" color=\"#ff4800\" margin-left=\"\" margin-right=\"10px\" ] 12 Main Street Pt. London\r\n[gdlr_core_space height=\"-9px\"]\r\n[gdlr_core_icon icon=\"fa fa-phone\" size=\"16px\" color=\"#ff4800\" margin-left=\"\" margin-right=\"10px\" ]  +1-3454-5678-77\r\n[gdlr_core_space height=\"-9px\"]\r\n[gdlr_core_icon icon=\"fa fa-envelope-open-o\" size=\"16px\" color=\"#ff4800\" margin-left=\"\" margin-right=\"10px\" ]  sales@goodlayers.com","filter":"content"},"3":{"title":"Text Widget","text":"Nulla vitae elit libero, a pharetra augue. Nulla vitae elit libero, a pharetra augue. Nulla vitae elit libero, a pharetra augue. Donec sed odio dui. Etiam porta sem malesuada.","filter":false},"4":{"title":"About Us","text":"Nulla vitae elit libero, a pharetra augue. Nulla vitae elit libero, a pharetra augue. Nulla vitae elit libero, a pharetra augue. Donec sed odio dui.","filter":false},"5":{"title":"Text Widget","text":"Nulla vitae elit libero, a pharetra augue. Nulla vitae elit libero, a pharetra augue. Nulla vitae elit libero, a pharetra augue. Donec sed odio dui. Etiam porta sem malesuada.","filter":false},"6":{"title":"","text":"[gdlr_core_button button-text=\"Get A Quote\" border-radius=\"3px\" background-color=\"#222\" button-background=\"solid\" button-link=\"http:\/\/demo.goodlayers.com\/realfactory\/contact\/\" button-link-target=\"_parent\" margin-right=\"20px\" ]","filter":false},"7":{"title":"","text":"[gdlr_core_space height=\"5px\"]","filter":"content"},"_multiwidget":1},"widget_woocommerce_layered_nav":{"_multiwidget":1},"widget_woocommerce_layered_nav_filters":{"_multiwidget":1},"widget_woocommerce_price_filter":{"2":{"title":"Filter by price"},"_multiwidget":1},"widget_woocommerce_product_categories":{"2":{"title":"Product categories","orderby":"name","dropdown":0,"count":0,"hierarchical":1,"show_children_only":0,"hide_empty":0},"_multiwidget":1},"widget_woocommerce_product_search":{"_multiwidget":1},"widget_woocommerce_product_tag_cloud":{"_multiwidget":1},"widget_woocommerce_products":{"_multiwidget":1},"widget_woocommerce_rating_filter":{"_multiwidget":1},"widget_woocommerce_recent_reviews":{"_multiwidget":1},"widget_woocommerce_recently_viewed_products":{"_multiwidget":1},"widget_woocommerce_top_rated_products":{"_multiwidget":1},"widget_woocommerce_widget_cart":{"2":{"title":"Cart","hide_if_empty":0},"_multiwidget":1},"widget_wpgmp_google_map_widget_class":{"_multiwidget":1}}',
					'theme-option' => '{"seocrawler_general":{"layout":"full","boxed-layout-top-margin":"0px","body-margin":"0px","background-type":"color","background-image":"","background-image-opacity":"100","background-pattern":"pattern-1","enable-boxed-border":"disable","item-padding":"20px","container-width":"1320px","container-padding":"40px","sidebar-width":"20","both-sidebar-width":"15","enable-top-bar":"enable","enable-top-bar-on-mobile":"enable","top-bar-width":"full","top-bar-width-pixel":"1140px","top-bar-full-side-padding":"10px","top-bar-left-text":"[gdlr_core_icon icon=\"fa fa-clock-o\" size=\"16px\" color=\"#ea4517\" margin-left=\"\" margin-right=\"10px\" ] <strong>Open<\/strong>  Mon - Fri 10:00-18:00","top-bar-right-text":"[gdlr_core_icon icon=\"fa fa-envelope-open-o\" size=\"16px\" color=\"#ea4517\" margin-left=\"\" margin-right=\"10px\" ] <strong>Email<\/strong>  Sales@GoodLayers.com [gdlr_core_icon icon=\"fa fa-phone\" size=\"16px\" color=\"#ea4517\" margin-left=\"20px\" margin-right=\"10px\" ] <strong>Call Now!<\/strong>  +1-3454-5678-77","top-bar-top-padding":"22px","top-bar-bottom-padding":"22px","top-bar-text-size":"15px","top-bar-bottom-border":"0px","enable-top-bar-social":"enable","top-bar-social-delicious":"","top-bar-social-email":"","top-bar-social-deviantart":"","top-bar-social-digg":"","top-bar-social-facebook":"#","top-bar-social-flickr":"","top-bar-social-google-plus":"#","top-bar-social-lastfm":"","top-bar-social-linkedin":"#","top-bar-social-pinterest":"#","top-bar-social-rss":"","top-bar-social-skype":"","top-bar-social-stumbleupon":"","top-bar-social-tumblr":"","top-bar-social-twitter":"#","top-bar-social-vimeo":"","top-bar-social-youtube":"","top-bar-social-instagram":"","top-bar-social-snapchat":"","header-style":"plain","header-plain-style":"menu-right","header-plain-bottom-border":"0px","header-bar-navigation-align":"center","header-background-style":"transparent","top-bar-background-opacity":"100","header-background-opacity":"0","navigation-background-opacity":"50","header-boxed-style":"menu-right","boxed-top-bar-background-opacity":"0","boxed-top-bar-background-extend":"0px","boxed-header-top-margin":"0px","header-side-style":"top-left","header-side-align":"left","header-side-toggle-style":"left","header-side-toggle-menu-type":"overlay","header-side-toggle-display-logo":"enable","header-width":"boxed","header-width-pixel":"1140px","header-full-side-padding":"15px","boxed-header-frame-radius":"3px","boxed-header-content-padding":"30px","navigation-text-top-margin":"0px","navigation-text-top-margin-boxed":"0px","navigation-text-side-spacing":"18px","navigation-slide-bar":"enable","side-header-width-pixel":"340px","side-header-side-padding":"70px","navigation-text-top-spacing":"16px","logo-right-text":"","logo-right-text-top-padding":"30px","logo":"4559","mobile-logo":"","logo-top-padding":"46px","logo-bottom-padding":"20px","logo-left-padding":"","max-logo-width":"212px","main-navigation-top-padding":"54px","main-navigation-bottom-padding":"35px","main-navigation-item-right-padding":"0px","main-navigation-right-padding":"","enable-main-navigation-submenu-indicator":"disable","enable-main-navigation-search":"enable","enable-main-navigation-cart":"disable","enable-main-navigation-right-button":"enable","main-navigation-right-button-text":"Get a quote","main-navigation-right-button-link":"\/seocrawler\/free-quote\/","main-navigation-right-button-link-target":"_self","right-menu-type":"right","right-menu-style":"hamburger","enable-main-navigation-sticky":"disable","enable-logo-on-main-navigation-sticky":"enable","fixed-navigation-max-logo-width":"150px","fixed-navigation-logo-top-padding":"23px","fixed-navigation-logo-bottom-padding":"20px","fixed-navigation-top-padding":"27px","fixed-navigation-bottom-padding":"27px","fixed-navigation-anchor-offset":"75px","default-title-style":"large","default-title-align":"center","default-title-top-padding":"93px","default-title-bottom-padding":"87px","default-page-caption-top-margin":"13px","default-title-font-transform":"none","default-title-font-size":"37px","default-title-font-weight":"","default-title-letter-spacing":"0px","default-caption-font-size":"16px","default-caption-font-weight":"","default-caption-letter-spacing":"0px","default-title-background-overlay-opacity":"0","default-title-background":"4561","default-portfolio-title-background":"","default-personnel-title-background":"","default-search-title-background":"","default-archive-title-background":"","default-404-background":"","default-404-background-opacity":"27","default-blog-title-style":"small","default-blog-title-top-padding":"93px","default-blog-title-bottom-padding":"87px","default-blog-feature-image":"title-background","default-blog-title-background-image":"","default-blog-title-background-overlay-opacity":"30","blog-sidebar":"none","blog-sidebar-left":"gdlr-core-sidebar-preset","blog-sidebar-right":"gdlr-core-sidebar-preset","blog-max-content-width":"900px","blog-thumbnail-size":"full","blog-date-feature":"enable","blog-date-feature-year":"disable","meta-option":["author","category","tag","comment-number"],"blog-author":"enable","blog-navigation":"enable","pagination-style":"round","pagination-align":"right","blog-social-share":"enable","blog-social-share-count":"enable","blog-social-facebook":"enable","blog-social-linkedin":"disable","blog-social-google-plus":"enable","blog-social-pinterest":"enable","blog-social-stumbleupon":"disable","blog-social-twitter":"enable","blog-social-email":"disable","archive-blog-sidebar":"right","archive-blog-sidebar-left":"gdlr-core-sidebar-preset","archive-blog-sidebar-right":"gdlr-core-sidebar-preset","archive-blog-style":"blog-full","archive-blog-full-alignment":"left","archive-thumbnail-size":"full","archive-show-thumbnail":"enable","archive-column-size":"20","archive-excerpt":"specify-number","archive-excerpt-number":"55","archive-date-feature":"enable","archive-meta-option":["date","author","category"],"archive-show-read-more":"enable","woocommerce-archive-sidebar":"right","woocommerce-archive-sidebar-left":"gdlr-core-sidebar-preset","woocommerce-archive-sidebar-right":"shop","woocommerce-archive-column-size":"30","woocommerce-archive-thumbnail":"Portfolio Thumbnail Portrait","woocommerce-related-product-column-size":"15","woocommerce-related-product-num-fetch":"4","woocommerce-related-product-thumbnail":"Blog Column Thumbnail","portfolio-slug":"portfolio","portfolio-category-slug":"portfolio_category","portfolio-tag-slug":"portfolio_tag","enable-single-portfolio-navigation":"enable","enable-single-portfolio-navigation-in-same-tag":"enable","portfolio-icon-hover-link":"icon_link_alt","portfolio-icon-hover-video":"icon_film","portfolio-icon-hover-image":"icon_zoom-in_alt","portfolio-icon-hover-size":"22px","enable-related-portfolio":"enable","related-portfolio-style":"grid","related-portfolio-column-size":"20","related-portfolio-num-fetch":"3","related-portfolio-thumbnail-size":"Portfolio Thumbnail","related-portfolio-num-excerpt":"20","archive-portfolio-sidebar":"none","archive-portfolio-sidebar-left":"gdlr-core-sidebar-preset","archive-portfolio-sidebar-right":"gdlr-core-sidebar-preset","archive-portfolio-style":"medium","archive-portfolio-thumbnail-size":"full","archive-portfolio-grid-text-align":"left","archive-portfolio-grid-style":"normal","archive-enable-portfolio-tag":"enable","archive-portfolio-medium-size":"small","archive-portfolio-medium-style":"switch","archive-portfolio-hover":"icon","archive-portfolio-column-size":"20","archive-portfolio-excerpt":"specify-number","archive-portfolio-excerpt-number":"55","personnel-slug":"personnel","personnel-category-slug":"personnel_category","fixed-footer":"disable","enable-footer":"enable","footer-top-padding":"70px","footer-bottom-padding":"50px","footer-style":"footer-2","enable-copyright":"enable","copyright-style":"left-right","copyright-top-padding":"30px","copyright-bottom-padding":"30px","copyright-font-letter-spacing":"0px","copyright-text-transform":"none","copyright-text":"","copyright-left":"[gdlr_core_icon icon=\"fa fa-facebook\" size=\"16px\" color=\"#ffffff\" margin-left=\"\" margin-right=\"20px\" link=\"#\" link-target=\"_blank\"] [gdlr_core_icon icon=\"fa fa-twitter\" size=\"16px\" color=\"#ffffff\" margin-left=\"\" margin-right=\"20px\" link=\"#\" link-target=\"_blank\"] [gdlr_core_icon icon=\"fa fa-linkedin\" size=\"16px\" color=\"#ffffff\" margin-left=\"\" margin-right=\"20px\" link=\"#\" link-target=\"_blank\"] [gdlr_core_icon icon=\"fa fa-pinterest-p\" size=\"16px\" color=\"#ffffff\" margin-left=\"\" margin-right=\"20px\" link=\"#\" link-target=\"_blank\"] [gdlr_core_icon icon=\"fa fa-vimeo\" size=\"16px\" color=\"#ffffff\" margin-left=\"\" margin-right=\"20px\" link=\"#\" link-target=\"_blank\"]","copyright-right":"Copyright 2017 GoodLayers, All Right Reserved","enable-back-to-top":"enable","related-portfolio-enable-tag":"disable","related-portfolio-thumbnail-hover":"title","related-portfolio-title-font-size":"15px","related-portfolio-title-font-weight":"500","boxed-layout-border-radius":"0px"},"seocrawler_typography":{"heading-font":"Poppins","navigation-font":"Nunito","content-font":"Poppins","info-font":"Poppins","blog-info-font":"Poppins","quote-font":"Droid Serif","additional-font":"Georgia, serif","additional-font2":"Georgia, serif","h1-font-size":"52px","h2-font-size":"48px","h3-font-size":"36px","h4-font-size":"28px","h5-font-size":"22px","h6-font-size":"18px","navigation-font-size":"14px","navigation-font-weight":"800","navigation-font-letter-spacing":"","navigation-text-transform":"uppercase","content-font-size":"16px","content-line-height":"1.7","testimonial-font":"Droid Serif"},"seocrawler_color":{"page-preload-background-color":"#ffffff","top-bar-background-color":"#ffffff","top-bar-bottom-border-color":"#ffffff","top-bar-text-color":"#ea4517","top-bar-link-color":"#ffffff","top-bar-link-hover-color":"#ffffff","top-bar-social-color":"#ea4517","top-bar-social-hover-color":"#000000","header-background-color":"#191919","header-plain-bottom-border-color":"#e8e8e8","navigation-bar-background-color":"#f4f4f4","navigation-bar-top-border-color":"#e8e8e8","navigation-slide-bar-color":"#ea4517","logo-background-color":"#ffffff","navigation-bar-right-icon-color":"#ffffff","woocommerce-cart-icon-number-background":"#ea4517","woocommerce-cart-icon-number-color":"#ffffff","secondary-menu-icon-color":"#ffffff","secondary-menu-border-color":"#dddddd","search-overlay-background-color":"#000000","top-cart-background-color":"#303030","top-cart-text-color":"#b5b5b5","top-cart-view-cart-color":"#ffffff","top-cart-checkout-color":"#ea4517","breadcrumbs-text-color":"#c0c0c0","breadcrumbs-text-active-color":"#777777","main-menu-text-color":"#ffffff","main-menu-text-hover-color":"#ffffff","sub-menu-background-color":"#f3f3f3","sub-menu-text-color":"#6d6d6d","sub-menu-text-hover-color":"#ea4517","sub-menu-text-hover-background-color":"#ffffff","sub-mega-menu-title-color":"#3f3f3f","sub-mega-menu-divider-color":"#e0e0e0","side-menu-text-color":"#979797","side-menu-text-hover-color":"#ffffff","side-menu-background-color":"#1f1f1f","side-menu-border-color":"#626262","overlay-menu-background-color":"#000000","overlay-menu-border-color":"#424242","overlay-menu-text-color":"#ffffff","overlay-menu-text-hover-color":"#a8a8a8","anchor-bullet-background-color":"#777777","anchor-bullet-background-active-color":"#ffffff","navigation-right-button-text-color":"#ffffff","navigation-right-button-background-color":"#ea4517","navigation-right-button-border-color":"#333333","navigation-right-button-text-hover-color":"#ea4517","navigation-right-button-background-hover-color":"#ffffff","navigation-right-button-border-hover-color":"#555555","body-background-color":"#ffffff","container-background-color":"#ffffff","page-title-color":"#ffffff","page-caption-color":"#ffffff","page-title-background-overlay-color":"#000000","body-content-color":"#6e6e6e","heading-color":"#383838","link-color":"#545454","link-hover-color":"#333333","divider-color":"#e6e6e6","input-box-background-color":"#f3f3f3","input-box-border-color":"#d7d7d7","input-box-text-color":"#7c7c7c","input-box-placeholder-color":"#7c7c7c","404-content-background-color":"#23618e","404-head-color":"#ffffff","404-title-color":"#ffffff","404-caption-color":"#c3e7ff","404-input-background-color":"#000000","404-input-text-color":"#ffffff","404-back-to-home-color":"#ffffff","sidebar-title-color":"#383838","sidebar-link-color":"#484848","sidebar-link-hover-color":"#323232","recent-post-widget-info-icon-color":"#9c9c9c","recent-post-widget-info-link-color":"#a0a0a0","post-slider-widget-title-color":"#ffffff","post-slider-widget-info-color":"#9c9c9c","search-box-text-color":"#b5b5b5","search-box-border-color":"#e0e0e0","search-box-icon-color":"#c7c7c7","twitter-widget-icon-color":"#303030","twitter-widget-date-color":"#b5b5b5","footer-background-color":"#202020","footer-title-color":"#ffffff","footer-content-color":"#ffffff","footer-link-color":"#ea4517","footer-link-hover-color":"#ffffff","footer-divider-color":"#303030","copyright-background-color":"#181818","copyright-text-color":"#838383","copyright-link-color":"#838383","copyright-link-hover-color":"#838383","back-to-top-background-color":"#dbdbdb","back-to-top-text-color":"#313131","single-blog-title-color":"#ffffff","single-blog-info-color":"#ffffff","single-blog-date-day-color":"#ffffff","single-blog-date-month-color":"#b1b1b1","single-blog-divider-color":"#ffffff","single-blog-title-background-overlay-color":"#000000","single-blog-author-title-color":"#464646","single-blog-author-caption-color":"#b1b1b1","single-blog-navigation-color":"#bcbcbc","single-blog-comment-title-color":"#464646","single-blog-comment-background-color":"#f9f9f9","single-blog-comment-reply-color":"#bcbcbc","single-blog-comment-time-color":"#b1b1b1","blog-title-color":"#343434","blog-title-hover-color":"#343434","blog-sticky-banner-color":"#444444","blog-sticky-banner-background":"#f3f3f3","blog-info-color":"#989898","blog-date-day-color":"#353535","blog-date-month-color":"#8a8a8a","blog-frame-background-color":"#ffffff","blog-modern-text-color":"#ffffff","blog-aside-background-color":"#ea4517","blog-aside-text-color":"#ffffff","pagination-background-color":"#e8e8e8","pagination-text-color":"#929292","pagination-background-hover-color":"#ea4517","pagination-text-hover-color":"#ffffff","pagination-plain-color":"#b4b4b4","pagination-plain-hover-color":"#424242","single-portfolio-nav-color":"#bcbcbc","portfolio-frame-background-color":"#ffffff","portfolio-title-color":"#3a3a3a","portfolio-info-head-color":"#343434","portfolio-info-color":"#b1b1b1","portfolio-badge-text-color":"#ffffff","portfolio-badge-background-color":"#ea4517","portfolio-thumbnail-title-color":"#ffffff","portfolio-thumbnail-info-color":"#cecece","portfolio-text-filter-color":"#aaaaaa","portfolio-text-filter-active-color":"#ea4517","portfolio-button-filter-text-color":"#838383","portfolio-button-filter-background-color":"#f1f1f1","portfolio-button-filter-text-active-color":"#ffffff","portfolio-button-filter-background-active-color":"#ea4517","price-table-background-color":"#f8f8f8","price-table-head-color":"#3e3e3e","price-table-head-top-gradient-color":"#525252","price-table-icon-color":"#ffffff","price-table-title-color":"#ffffff","price-table-caption-color":"#acacac","price-table-price-background-color":"#ebebeb","price-table-price-color":"#323232","price-table-price-suffix-color":"#acacac","price-table-price-button-color":"#ffffff","price-table-button-background-color":"#575757","price-table-button-background-top-gradient-color":"#414141","price-table-list-border-color":"#e5e5e5","price-table-active-head-color":"#ea4517","price-table-active-head-top-gradient-color":"#d62e00","price-table-active-icon-color":"#ffffff","price-table-active-title-color":"#ffffff","price-table-active-caption-color":"#ffdcd1","price-table-active-price-background-color":"#ffffff","price-table-active-price-color":"#323232","price-table-active-price-suffix-color":"#acacac","price-table-active-price-button-color":"#ffffff","price-table-active-button-background-color":"#ea4517","price-table-active-button-background-top-gradient-color":"#ea7352","accordion-normal-icon-color":"#191919","accordion-normal-title-head-color":"#191919","accordion-normal-title-color":"#191919","accordion-normal-icon-background-color":"#f3f3f3","accordion-icon-color":"#191919","accordion-title-head-color":"#191919","accordion-title-color":"#191919","accordion-title-background-color":"#f3f3f3","accordion-icon-active-color":"#191919","accordion-title-active-color":"#191919","accordion-title-background-active-color":"#f3f3f3","audio-background-color":"#e7e7e7","audio-text-color":"#202020","audio-content-background-color":"#afafaf","audio-content-progress-color":"#ea4517","audio-volume-background-color":"#afafaf","audio-volume-progress-color":"#646464","alert-box-item-background-color":"#ef5e68","alert-box-item-border-color":"#cd515a","alert-box-item-content-color":"#ffffff","alert-box-item-title-color":"#ffffff","blockquote-text-color":"#777777","blockquote-background-color":"#f5f5f5","blockquote-border-color":"#e2e2e2","blockquote-item-icon-color":"#4e4e4e","blockquote-item-content-color":"#4e4e4e","button-text-color":"#ffffff","button-text-hover-color":"#ffffff","button-background-color":"#ea4517","button-background-hover-color":"#2F2F2F","button-border-color":"#383838","button-border-hover-color":"#000000","button-gradient-background-color":"#ea4517","button-top-gradient-background-color":"#ea7656","call-to-action-title-color":"#2c2c2c","call-to-action-caption-color":"#535353","counter-item-top-text-color":"#828282","counter-item-top-icon-color":"#393939","counter-item-number-color":"#393939","counter-item-divider-color":"#393939","counter-item-bottom-text-color":"#393939","column-service-icon-color":"#9d9d9d","column-service-icon-background":"#f3f3f3","column-service-title-color":"#383838","column-service-caption-color":"#747474","dropdown-tab-head-background":"#ea4517","dropdown-tab-head-text":"#252525","flipbox-background-color":"#2d9bea","flipbox-border-color":"#2a80be","flipbox-icon-color":"#ffffff","flipbox-title-color":"#ffffff","flipbox-caption-color":"#ffffff","flipbox-content-color":"#ffffff","gallery-overlay-title":"#ffffff","gallery-overlay-caption":"#cecece","image-overlay-background-color":"#000000","image-overlay-icon-color":"#ffffff","image-overlay-icon-background":"#ffffff","image-item-border-color":"#000000","item-title-color":"#343434","item-title-caption-color":"#747474","item-title-link-color":"#747474","icon-list-item-icon-color":"#222222","icon-list-item-icon-background-color":"#f3f3f3","opening-hour-day-color":"#a5a5a5","opening-hour-open-color":"#262626","opening-hour-close-color":"#c8c8c8","opening-hour-icon-color":"#8a8989","opening-hour-divider-color":"#a6a6a6","personnel-grid-title-color":"#383838","personnel-grid-position-color":"#888888","personnel-grid-divider-color":"#cecece","personnel-grid-frame-color":"#f9f9f9","personnel-modern-title-color":"#ffffff","personnel-modern-position-color":"#ffffff","promo-box-item-title-color":"#383838","promo-box-content-border-color":"#e8e7e7","post-slider-title-color":"#ffffff","post-slider-info-color":"#c5c5c5","skill-bar-title-color":"#505050","skill-bar-icon-color":"#616161","skill-bar-background-color":"#f3f3f3","skill-bar-progress-color":"#ea4517","slider-outer-navigation-color":"#a7a7a7","slider-outer-navigation-background-color":"#f1f1f1","slider-control-navigation-color":"#8a8a8a","social-share-icon-color":"#202020","social-share-divider-color":"#e5e5e5","social-share-text-color":"#202020","stunning-text-title-color":"#747474","stunning-text-caption-color":"#383838","tab-title-color":"#8d8d8d","tab-title-background-color":"#f7f7f7","tab-title-border-color":"#ebebeb","tab-title-hover-bar-color":"#ea4517","tab-title-active-color":"#464646","tab-title-active-background-color":"#ffffff","table-head-background-color":"#ea4517","table-head-text-color":"#ffffff","table-odd-background-color":"#f9f9f9","table-odd-text-color":"#949494","table-even-background":"#f3f3f3","table-even-text":"#949494","testimonial-title-color":"#232323","testimonial-content-color":"#707070","testimonial-author-color":"#3b3b3b","testimonial-rating-color":"#ffa127","testimonial-position-color":"#3b3b3b","testimonial-quote-color":"#282828","title-item-title-color":"#383838","title-item-caption-color":"#747474","woocommerce-theme-color":"#ea4517","woocommerce-price-color":"#ea4517","woocommerce-price-linethrough-color":"#949494","woocommerce-button-background-hover-color":"#ea4517","woocommerce-button-text-color":"#ffffff","woocommerce-button-text-hover-color":"#ffffff","woocommerce-input-background-color":"#f3f3f3","product-item-title-color":"#191919","product-item-title-hover-color":"#434343","view-detail-text-color":"#ffffff","view-detail-background-color":"#000000","add-to-cart-text-color":"#ffffff","add-to-cart-background-color":"#ea4517","widget-price-filter-bar-background-color":"#e6e6e6","widget-price-filter-range-color":"#9e3200","widget-price-filter-handle-color":"#ea4517","skin":[{"name":"Dark","title":"#ffffff","title-hover":"","caption":"#d3d3d3","content":"#d6d6d6","icon":"#e5e5e5","link":"#ffffff","link-hover":"#bfbfbf","divider":"#a3a3a3","border":"#a0a0a0","element-background":"#000000","element-content":"#e5e5e5","button-text":"","button-text-hover":"","button-background":"#212121","button-background-hover":"","button-border-color":"","button-border-hover-color":""},{"name":"Dark Port","title":"#ffffff","title-hover":"","caption":"#ffffff","content":"#ffffff","icon":"#ffffff","link":"","link-hover":"","divider":"","border":"","element-background":"#ffffff","element-content":"#ffffff","button-text":"","button-text-hover":"","button-background":"#212121","button-background-hover":"#212121","button-border-color":"","button-border-hover-color":""},{"name":"Purple","title":"","title-hover":"","caption":"","content":"#abb1ff","icon":"","link":"","link-hover":"","divider":"","border":"","element-background":"","element-content":"","button-text":"","button-text-hover":"","button-background":"","button-background-hover":"","button-border-color":"","button-border-hover-color":""},{"name":"Red Dark","title":"","title-hover":"","caption":"","content":"#d0888b","icon":"","link":"","link-hover":"","divider":"","border":"","element-background":"","element-content":"","button-text":"","button-text-hover":"","button-background":"","button-background-hover":"","button-border-color":"","button-border-hover-color":""},{"name":"Port Carousel","title":"","title-hover":"","caption":"","content":"","icon":"#6d6d6d","link":"","link-hover":"","divider":"","border":"","element-background":"","element-content":"","button-text":"","button-text-hover":"","button-background":"","button-background-hover":"","button-border-color":"","button-border-hover-color":""},{"name":"About Orange","title":"#ffffff","title-hover":"","caption":"#ffffff","content":"#ff4800","icon":"","link":"","link-hover":"","divider":"","border":"","element-background":"","element-content":"","button-text":"","button-text-hover":"","button-background":"","button-background-hover":"","button-border-color":"","button-border-hover-color":""},{"name":"Contact form white","title":"","title-hover":"","caption":"","content":"","icon":"","link":"","link-hover":"","divider":"","border":"","element-background":"#ffffff","element-content":"","button-text":"","button-text-hover":"","button-background":"","button-background-hover":"","button-border-color":"","button-border-hover-color":""},{"name":"Contact form grey","title":"","title-hover":"","caption":"","content":"","icon":"","link":"","link-hover":"","divider":"","border":"","element-background":"#ffffff","element-content":"#7f7f7f","button-text":"","button-text-hover":"","button-background":"#81ca41","button-background-hover":"","button-border-color":"","button-border-hover-color":""},{"name":"Purple Counter","title":"#ffffff","title-hover":"","caption":"#9bb6f3","content":"#9bb6f3","icon":"#ffffff","link":"","link-hover":"","divider":"","border":"","element-background":"","element-content":"","button-text":"","button-text-hover":"","button-background":"","button-background-hover":"","button-border-color":"","button-border-hover-color":""},{"name":"CTA Purple","title":"#ffffff","title-hover":"","caption":"#aac1f6","content":"#aac1f6","icon":"","link":"","link-hover":"","divider":"","border":"","element-background":"","element-content":"","button-text":"#ffffff","button-text-hover":"","button-background":"#81ca41","button-background-hover":"","button-border-color":"","button-border-hover-color":""},{"name":"CTA HP3","title":"#ffffff","title-hover":"","caption":"#ffffff","content":"#ffffff","icon":"","link":"","link-hover":"","divider":"","border":"","element-background":"","element-content":"","button-text":"","button-text-hover":"","button-background":"#43a351","button-background-hover":"","button-border-color":"","button-border-hover-color":""},{"name":"HP3 Service","title":"#ffffff","title-hover":"","caption":"#c9fed1","content":"#c9fed1","icon":"","link":"","link-hover":"","divider":"","border":"","element-background":"","element-content":"","button-text":"#383838","button-text-hover":"#383838","button-background":"#ffffff","button-background-hover":"","button-border-color":"","button-border-hover-color":""},{"name":"Contact form green","title":"#ffffff","title-hover":"","caption":"","content":"","icon":"","link":"","link-hover":"","divider":"","border":"","element-background":"#ffffff","element-content":"#b7b7b7","button-text":"#ffffff","button-text-hover":"","button-background":"#2c2c2c","button-background-hover":"#43a351","button-border-color":"","button-border-hover-color":""},{"name":"Landing Plugin","title":"","title-hover":"","caption":"","content":"#b9d2ff","icon":"","link":"","link-hover":"","divider":"","border":"","element-background":"","element-content":"","button-text":"","button-text-hover":"","button-background":"","button-background-hover":"","button-border-color":"","button-border-hover-color":""}],"sub-mega-menu-content-color":"#999999"},"seocrawler_plugin":{"enable-srcset":"enable","lightbox":"ilightbox","ilightbox-skin":"dark","link-to-lightbox":"enable","additional-css":"","additional-mobile-css":"","additional-head-script":"","additional-script":"","enable-maintenance":"disable","maintenance-page":"2","enable-preload":"disable","preload-image":"","thumbnail-sizing":[{"name":"Personnel Thumbnail","width":"700","height":"500","hard-crop":""},{"name":"Portfolio Thumbnail","width":"700","height":"450","hard-crop":""},{"name":"Portfolio Thumbnail Portrait","width":"700","height":"660","hard-crop":""},{"name":"Portfolio Thumbnail Portrait 2","width":"600","height":"800","hard-crop":""},{"name":"Large Landscape ","width":"1550","height":"700","hard-crop":""},{"name":"Portfolio Side Description Large","width":"900","height":"500","hard-crop":""},{"name":"Blog Full Thumbnail","width":"1100","height":"490","hard-crop":""},{"name":"Blog Column Thumbnail","width":"700","height":"430","hard-crop":""},{"name":"Personnel Square","width":"600","height":"600","hard-crop":""},{"name":"Personnel Thumbnail","width":"500","height":"655","hard-crop":""}]}}'
				),
				'seocrawler-demo2' => array(
					'title' => esc_html__('SEO Crawler - Demo 2', 'seocrawler'),
					'url' => 'http://demo.goodlayers.com/seocrawler/demo2',
					'xml' => get_template_directory() . '/admin/function/files/seocrawler-demo2.xml',
					'page' => 4931,
					'menu' => array('main_menu' => 27, 'mobile_menu' => 27),
					'widget' => '{"gdlrcst_sidebar_name":[{"name":"Elements","id":"elements"},{"name":"Blog","id":"blog"},{"name":"Blog Left","id":"blog-left"},{"name":"Blog Right","id":"blog-right"},{"name":"Shop","id":"shop"}],"sidebars_widgets":{"wp_inactive_widgets":["nav_menu-1","nav_menu-2","text-6"],"gdlr-core-sidebar-preset":["search-2","recent-posts-2","recent-comments-2","archives-2","categories-2","meta-2"],"footer-1":["text-1"],"footer-2":["text-2"],"footer-3":["nav_menu-3"],"footer-4":["text-7","nav_menu-4"],"elements":[],"blog":["text-3","gdlr-core-recent-portfolio-widget-2","recent-comments-3","tag_cloud-1"],"blog-left":["search-3","text-4","recent-posts-4","gdlr-core-portfolio-slider-widget-1"],"blog-right":["text-5","recent-comments-4","tag_cloud-2"],"shop":[],"array_version":3},"widget_archives":{"2":{"title":"","count":0,"dropdown":0},"_multiwidget":1},"widget_calendar":{"_multiwidget":1},"widget_categories":{"2":{"title":"","count":0,"hierarchical":0,"dropdown":0},"_multiwidget":1},"widget_gdlr-core-portfolio-slider-widget":{"1":{"title":"Recent Works","category":"","num-fetch":"3","thumbnail-size":"Frame Landscape 2"},"_multiwidget":1},"widget_gdlr-core-post-slider-widget":{"_multiwidget":1},"widget_gdlr-core-recent-portfolio-widget":{"2":{"title":"Recent Works","category":"","num-fetch":"9"},"_multiwidget":1},"widget_gdlr-core-recent-post-widget":{"_multiwidget":1},"widget_gdlr-core-twitter-widget":{"_multiwidget":1},"widget_media_audio":{"_multiwidget":1},"widget_media_image":{"_multiwidget":1},"widget_media_video":{"_multiwidget":1},"widget_meta":{"2":{"title":""},"_multiwidget":1},"widget_nav_menu":{"1":{"title":"Market Sectors","nav_menu":69},"2":{"title":"Useful Links","nav_menu":70},"3":{"title":"Our Services","nav_menu":28},"4":{"nav_menu":29},"_multiwidget":1},"widget_newsletterwidget":{"_multiwidget":1},"widget_newsletterwidgetminimal":{"_multiwidget":1},"widget_pages":{"_multiwidget":1},"widget_recent-comments":{"2":{"title":"","number":5},"3":{"title":"","number":5},"4":{"title":"","number":5},"_multiwidget":1},"widget_recent-posts":{"2":{"title":"","number":5},"4":{"title":"Recent Posts","number":5,"show_date":false},"_multiwidget":1},"widget_rev-slider-widget":{"_multiwidget":1},"widget_rss":{"1":[],"_multiwidget":1},"widget_search":{"2":{"title":""},"3":{"title":""},"_multiwidget":1},"widget_tag_cloud":{"1":{"title":"Tag Cloud","taxonomy":"post_tag"},"2":{"title":"Tag Cloud","taxonomy":"post_tag"},"_multiwidget":1},"widget_text":{"1":{"title":"About Us","text":"<span style=\"font-size: 14px; color: #ababab;\">Far far away, behind the word mountains, far from the countries Vokalia and Consonantia, there live the blind texts.<\/span>\r\n\r\n[gdlr_core_space height=\"21px\"]\r\n<img src=\"http:\/\/demo.goodlayers.com\/seocrawler\/demo2\/wp-content\/uploads\/2017\/07\/logo-white.png\" alt=\"\" \/>","filter":"content"},"2":{"title":"Contact Info","text":"[gdlr_core_icon icon=\"fa fa-location-arrow\" size=\"16px\" color=\"#6091e5\" margin-left=\"\" margin-right=\"10px\" ] 12 Main Street Pt. London\r\n[gdlr_core_space height=\"-9px\"]\r\n[gdlr_core_icon icon=\"fa fa-phone\" size=\"16px\" color=\"#6091e5\" margin-left=\"\" margin-right=\"10px\" ] +1-3454-5678-77\r\n[gdlr_core_space height=\"-9px\"]\r\n[gdlr_core_icon icon=\"fa fa-envelope-open-o\" size=\"16px\" color=\"#6091e5\" margin-left=\"\" margin-right=\"10px\" ] sales@goodlayers.com","filter":"content"},"3":{"title":"Text Widget","text":"Nulla vitae elit libero, a pharetra augue. Nulla vitae elit libero, a pharetra augue. Nulla vitae elit libero, a pharetra augue. Donec sed odio dui. Etiam porta sem malesuada.","filter":false},"4":{"title":"About Us","text":"Nulla vitae elit libero, a pharetra augue. Nulla vitae elit libero, a pharetra augue. Nulla vitae elit libero, a pharetra augue. Donec sed odio dui.","filter":false},"5":{"title":"Text Widget","text":"Nulla vitae elit libero, a pharetra augue. Nulla vitae elit libero, a pharetra augue. Nulla vitae elit libero, a pharetra augue. Donec sed odio dui. Etiam porta sem malesuada.","filter":false},"6":{"title":"","text":"[gdlr_core_button button-text=\"Get A Quote\" border-radius=\"3px\" background-color=\"#222\" button-background=\"solid\" button-link=\"http:\/\/demo.goodlayers.com\/realfactory\/contact\/\" button-link-target=\"_parent\" margin-right=\"20px\" ]","filter":false},"7":{"title":"","text":"[gdlr_core_space height=\"5px\"]","filter":"content"},"_multiwidget":1},"widget_woocommerce_layered_nav":{"_multiwidget":1},"widget_woocommerce_layered_nav_filters":{"_multiwidget":1},"widget_woocommerce_price_filter":{"2":{"title":"Filter by price"},"_multiwidget":1},"widget_woocommerce_product_categories":{"2":{"title":"Product categories","orderby":"name","dropdown":0,"count":0,"hierarchical":1,"show_children_only":0,"hide_empty":0},"_multiwidget":1},"widget_woocommerce_product_search":{"_multiwidget":1},"widget_woocommerce_product_tag_cloud":{"_multiwidget":1},"widget_woocommerce_products":{"_multiwidget":1},"widget_woocommerce_rating_filter":{"_multiwidget":1},"widget_woocommerce_recent_reviews":{"_multiwidget":1},"widget_woocommerce_recently_viewed_products":{"_multiwidget":1},"widget_woocommerce_top_rated_products":{"_multiwidget":1},"widget_woocommerce_widget_cart":{"2":{"title":"Cart","hide_if_empty":0},"_multiwidget":1},"widget_wpgmp_google_map_widget_class":{"_multiwidget":1}}',
					'theme-option' => '{"seocrawler_general":{"layout":"full","boxed-layout-top-margin":"0px","body-margin":"0px","background-type":"color","background-image":"","background-image-opacity":"100","background-pattern":"pattern-1","enable-boxed-border":"disable","item-padding":"20px","container-width":"1280px","container-padding":"40px","sidebar-width":"20","both-sidebar-width":"15","enable-top-bar":"enable","enable-top-bar-on-mobile":"enable","top-bar-width":"full","top-bar-width-pixel":"1140px","top-bar-full-side-padding":"10px","top-bar-left-text":"[gdlr_core_icon icon=\"fa fa-clock-o\" size=\"16px\" color=\"#3f3f3f\" margin-left=\"\" margin-right=\"10px\" ] <strong>Open<\/strong>  Mon - Fri 10:00-18:00","top-bar-right-text":"[gdlr_core_icon icon=\"fa fa-envelope-open-o\" size=\"16px\" color=\"#3f3f3f\" margin-left=\"\" margin-right=\"10px\" ] <strong>Email<\/strong>  Sales@GoodLayers.com [gdlr_core_icon icon=\"fa fa-phone\" size=\"16px\" color=\"#3f3f3f\" margin-left=\"20px\" margin-right=\"10px\" ] <strong>Call Now!<\/strong>  +1-3454-5678-77","top-bar-top-padding":"22px","top-bar-bottom-padding":"22px","top-bar-text-size":"15px","top-bar-bottom-border":"0px","enable-top-bar-social":"enable","top-bar-social-delicious":"","top-bar-social-email":"","top-bar-social-deviantart":"","top-bar-social-digg":"","top-bar-social-facebook":"#","top-bar-social-flickr":"","top-bar-social-google-plus":"#","top-bar-social-lastfm":"","top-bar-social-linkedin":"#","top-bar-social-pinterest":"#","top-bar-social-rss":"","top-bar-social-skype":"","top-bar-social-stumbleupon":"","top-bar-social-tumblr":"","top-bar-social-twitter":"#","top-bar-social-vimeo":"","top-bar-social-youtube":"","top-bar-social-instagram":"","top-bar-social-snapchat":"","header-style":"plain","header-plain-style":"menu-right","header-plain-bottom-border":"0px","header-bar-navigation-align":"center","header-background-style":"solid","top-bar-background-opacity":"100","header-background-opacity":"0","navigation-background-opacity":"50","header-boxed-style":"menu-right","boxed-top-bar-background-opacity":"0","boxed-top-bar-background-extend":"0px","boxed-header-top-margin":"0px","header-side-style":"top-left","header-side-align":"left","header-side-toggle-style":"left","header-side-toggle-menu-type":"overlay","header-side-toggle-display-logo":"enable","header-width":"boxed","header-width-pixel":"1140px","header-full-side-padding":"15px","boxed-header-frame-radius":"3px","boxed-header-content-padding":"30px","navigation-text-top-margin":"0px","navigation-text-top-margin-boxed":"0px","navigation-text-side-spacing":"18px","navigation-slide-bar":"enable","side-header-width-pixel":"340px","side-header-side-padding":"70px","navigation-text-top-spacing":"16px","logo-right-text":"","logo-right-text-top-padding":"30px","logo":"4997","mobile-logo":"","logo-top-padding":"43px","logo-bottom-padding":"48px","logo-left-padding":"","max-logo-width":"212px","main-navigation-top-padding":"49px","main-navigation-bottom-padding":"47px","main-navigation-item-right-padding":"0px","main-navigation-right-padding":"","enable-main-navigation-submenu-indicator":"disable","enable-main-navigation-search":"enable","enable-main-navigation-cart":"disable","enable-main-navigation-right-button":"enable","main-navigation-right-button-text":"Get a quote","main-navigation-right-button-link":"\/seocrawler\/demo2\/free-quote\/","main-navigation-right-button-link-target":"_self","right-menu-type":"right","right-menu-style":"hamburger","enable-main-navigation-sticky":"enable","enable-logo-on-main-navigation-sticky":"enable","fixed-navigation-max-logo-width":"150px","fixed-navigation-logo-top-padding":"23px","fixed-navigation-logo-bottom-padding":"20px","fixed-navigation-top-padding":"27px","fixed-navigation-bottom-padding":"27px","fixed-navigation-anchor-offset":"75px","default-title-style":"large","default-title-align":"center","default-title-top-padding":"93px","default-title-bottom-padding":"87px","default-page-caption-top-margin":"13px","default-title-font-transform":"none","default-title-font-size":"37px","default-title-font-weight":"","default-title-letter-spacing":"0px","default-caption-font-size":"16px","default-caption-font-weight":"","default-caption-letter-spacing":"0px","default-title-background-overlay-opacity":"0","default-title-background":"4561","default-portfolio-title-background":"","default-personnel-title-background":"","default-search-title-background":"","default-archive-title-background":"","default-404-background":"","default-404-background-opacity":"27","default-blog-title-style":"small","default-blog-title-top-padding":"93px","default-blog-title-bottom-padding":"87px","default-blog-feature-image":"title-background","default-blog-title-background-image":"","default-blog-title-background-overlay-opacity":"30","blog-sidebar":"none","blog-sidebar-left":"gdlr-core-sidebar-preset","blog-sidebar-right":"gdlr-core-sidebar-preset","blog-max-content-width":"900px","blog-thumbnail-size":"full","blog-date-feature":"enable","blog-date-feature-year":"disable","meta-option":["author","category","tag","comment-number"],"blog-author":"enable","blog-navigation":"enable","pagination-style":"round","pagination-align":"right","blog-social-share":"enable","blog-social-share-count":"enable","blog-social-facebook":"enable","blog-social-linkedin":"disable","blog-social-google-plus":"enable","blog-social-pinterest":"enable","blog-social-stumbleupon":"disable","blog-social-twitter":"enable","blog-social-email":"disable","archive-blog-sidebar":"right","archive-blog-sidebar-left":"gdlr-core-sidebar-preset","archive-blog-sidebar-right":"gdlr-core-sidebar-preset","archive-blog-style":"blog-full","archive-blog-full-alignment":"left","archive-thumbnail-size":"full","archive-show-thumbnail":"enable","archive-column-size":"20","archive-excerpt":"specify-number","archive-excerpt-number":"55","archive-date-feature":"enable","archive-meta-option":["date","author","category"],"archive-show-read-more":"enable","woocommerce-archive-sidebar":"right","woocommerce-archive-sidebar-left":"gdlr-core-sidebar-preset","woocommerce-archive-sidebar-right":"shop","woocommerce-archive-column-size":"30","woocommerce-archive-thumbnail":"Portfolio Thumbnail Portrait","woocommerce-related-product-column-size":"15","woocommerce-related-product-num-fetch":"4","woocommerce-related-product-thumbnail":"Blog Column Thumbnail","portfolio-slug":"portfolio","portfolio-category-slug":"portfolio_category","portfolio-tag-slug":"portfolio_tag","enable-single-portfolio-navigation":"enable","enable-single-portfolio-navigation-in-same-tag":"enable","portfolio-icon-hover-link":"icon_link_alt","portfolio-icon-hover-video":"icon_film","portfolio-icon-hover-image":"icon_zoom-in_alt","portfolio-icon-hover-size":"22px","enable-related-portfolio":"enable","related-portfolio-style":"grid","related-portfolio-column-size":"20","related-portfolio-num-fetch":"3","related-portfolio-thumbnail-size":"Portfolio Thumbnail","related-portfolio-num-excerpt":"20","archive-portfolio-sidebar":"none","archive-portfolio-sidebar-left":"gdlr-core-sidebar-preset","archive-portfolio-sidebar-right":"gdlr-core-sidebar-preset","archive-portfolio-style":"medium","archive-portfolio-thumbnail-size":"full","archive-portfolio-grid-text-align":"left","archive-portfolio-grid-style":"normal","archive-enable-portfolio-tag":"enable","archive-portfolio-medium-size":"small","archive-portfolio-medium-style":"switch","archive-portfolio-hover":"icon","archive-portfolio-column-size":"20","archive-portfolio-excerpt":"specify-number","archive-portfolio-excerpt-number":"55","personnel-slug":"personnel","personnel-category-slug":"personnel_category","fixed-footer":"disable","enable-footer":"enable","footer-top-padding":"70px","footer-bottom-padding":"50px","footer-style":"footer-2","enable-copyright":"enable","copyright-style":"left-right","copyright-top-padding":"30px","copyright-bottom-padding":"30px","copyright-font-letter-spacing":"0px","copyright-text-transform":"none","copyright-text":"","copyright-left":"[gdlr_core_icon icon=\"fa fa-facebook\" size=\"16px\" color=\"#ffffff\" margin-left=\"\" margin-right=\"20px\" link=\"#\" link-target=\"_blank\"] [gdlr_core_icon icon=\"fa fa-twitter\" size=\"16px\" color=\"#ffffff\" margin-left=\"\" margin-right=\"20px\" link=\"#\" link-target=\"_blank\"] [gdlr_core_icon icon=\"fa fa-linkedin\" size=\"16px\" color=\"#ffffff\" margin-left=\"\" margin-right=\"20px\" link=\"#\" link-target=\"_blank\"] [gdlr_core_icon icon=\"fa fa-pinterest-p\" size=\"16px\" color=\"#ffffff\" margin-left=\"\" margin-right=\"20px\" link=\"#\" link-target=\"_blank\"] [gdlr_core_icon icon=\"fa fa-vimeo\" size=\"16px\" color=\"#ffffff\" margin-left=\"\" margin-right=\"20px\" link=\"#\" link-target=\"_blank\"]","copyright-right":"Copyright 2017 GoodLayers, All Right Reserved","enable-back-to-top":"enable","related-portfolio-enable-tag":"disable","related-portfolio-thumbnail-hover":"title","related-portfolio-title-font-size":"15px","related-portfolio-title-font-weight":"500","boxed-layout-border-radius":"0px"},"seocrawler_typography":{"heading-font":"Poppins","navigation-font":"Nunito","content-font":"Poppins","info-font":"Poppins","blog-info-font":"Poppins","quote-font":"Droid Serif","additional-font":"Georgia, serif","additional-font2":"Georgia, serif","h1-font-size":"52px","h2-font-size":"48px","h3-font-size":"36px","h4-font-size":"28px","h5-font-size":"22px","h6-font-size":"18px","navigation-font-size":"14px","navigation-font-weight":"400","navigation-font-letter-spacing":"0px","navigation-text-transform":"uppercase","content-font-size":"16px","content-line-height":"1.7","testimonial-font":"Droid Serif"},"seocrawler_color":{"page-preload-background-color":"#ffffff","top-bar-background-color":"#f2f2f2","top-bar-bottom-border-color":"#ffffff","top-bar-text-color":"#424242","top-bar-link-color":"#ffffff","top-bar-link-hover-color":"#ffffff","top-bar-social-color":"#3155a7","top-bar-social-hover-color":"#000000","header-background-color":"#ffffff","header-plain-bottom-border-color":"#e8e8e8","navigation-bar-background-color":"#f4f4f4","navigation-bar-top-border-color":"#e8e8e8","navigation-slide-bar-color":"#3155a7","logo-background-color":"#ffffff","navigation-bar-right-icon-color":"#2d2d2d","woocommerce-cart-icon-number-background":"#3155a7","woocommerce-cart-icon-number-color":"#ffffff","secondary-menu-icon-color":"#ffffff","secondary-menu-border-color":"#dddddd","search-overlay-background-color":"#000000","top-cart-background-color":"#303030","top-cart-text-color":"#b5b5b5","top-cart-view-cart-color":"#ffffff","top-cart-checkout-color":"#3155a7","breadcrumbs-text-color":"#c0c0c0","breadcrumbs-text-active-color":"#777777","main-menu-text-color":"#999999","main-menu-text-hover-color":"#333333","sub-menu-background-color":"#f3f3f3","sub-menu-text-color":"#686868","sub-menu-text-hover-color":"#3155a7","sub-menu-text-hover-background-color":"#ffffff","sub-mega-menu-title-color":"#3a3a3a","sub-mega-menu-divider-color":"#e0e0e0","side-menu-text-color":"#979797","side-menu-text-hover-color":"#ffffff","side-menu-background-color":"#1f1f1f","side-menu-border-color":"#626262","overlay-menu-background-color":"#000000","overlay-menu-border-color":"#424242","overlay-menu-text-color":"#ffffff","overlay-menu-text-hover-color":"#a8a8a8","anchor-bullet-background-color":"#777777","anchor-bullet-background-active-color":"#ffffff","navigation-right-button-text-color":"#ffffff","navigation-right-button-background-color":"#3155a7","navigation-right-button-border-color":"#333333","navigation-right-button-text-hover-color":"#ffffff","navigation-right-button-background-hover-color":"#282828","navigation-right-button-border-hover-color":"#555555","body-background-color":"#ffffff","container-background-color":"#ffffff","page-title-color":"#ffffff","page-caption-color":"#ffffff","page-title-background-overlay-color":"#000000","body-content-color":"#6e6e6e","heading-color":"#383838","link-color":"#545454","link-hover-color":"#333333","divider-color":"#e6e6e6","input-box-background-color":"#f3f3f3","input-box-border-color":"#d7d7d7","input-box-text-color":"#7c7c7c","input-box-placeholder-color":"#7c7c7c","404-content-background-color":"#23618e","404-head-color":"#ffffff","404-title-color":"#ffffff","404-caption-color":"#c3e7ff","404-input-background-color":"#000000","404-input-text-color":"#ffffff","404-back-to-home-color":"#ffffff","sidebar-title-color":"#383838","sidebar-link-color":"#484848","sidebar-link-hover-color":"#323232","recent-post-widget-info-icon-color":"#9c9c9c","recent-post-widget-info-link-color":"#a0a0a0","post-slider-widget-title-color":"#ffffff","post-slider-widget-info-color":"#9c9c9c","search-box-text-color":"#b5b5b5","search-box-border-color":"#e0e0e0","search-box-icon-color":"#c7c7c7","twitter-widget-icon-color":"#303030","twitter-widget-date-color":"#b5b5b5","footer-background-color":"#202020","footer-title-color":"#ffffff","footer-content-color":"#ffffff","footer-link-color":"#6091e5","footer-link-hover-color":"#ffffff","footer-divider-color":"#303030","copyright-background-color":"#181818","copyright-text-color":"#838383","copyright-link-color":"#838383","copyright-link-hover-color":"#838383","back-to-top-background-color":"#dbdbdb","back-to-top-text-color":"#313131","single-blog-title-color":"#ffffff","single-blog-info-color":"#ffffff","single-blog-date-day-color":"#ffffff","single-blog-date-month-color":"#b1b1b1","single-blog-divider-color":"#ffffff","single-blog-title-background-overlay-color":"#000000","single-blog-author-title-color":"#464646","single-blog-author-caption-color":"#b1b1b1","single-blog-navigation-color":"#bcbcbc","single-blog-comment-title-color":"#464646","single-blog-comment-background-color":"#f9f9f9","single-blog-comment-reply-color":"#bcbcbc","single-blog-comment-time-color":"#b1b1b1","blog-title-color":"#343434","blog-title-hover-color":"#343434","blog-sticky-banner-color":"#444444","blog-sticky-banner-background":"#f3f3f3","blog-info-color":"#989898","blog-date-day-color":"#353535","blog-date-month-color":"#8a8a8a","blog-frame-background-color":"#ffffff","blog-modern-text-color":"#ffffff","blog-aside-background-color":"#3155a7","blog-aside-text-color":"#ffffff","pagination-background-color":"#e8e8e8","pagination-text-color":"#929292","pagination-background-hover-color":"#3155a7","pagination-text-hover-color":"#ffffff","pagination-plain-color":"#b4b4b4","pagination-plain-hover-color":"#424242","single-portfolio-nav-color":"#bcbcbc","portfolio-frame-background-color":"#ffffff","portfolio-title-color":"#3a3a3a","portfolio-info-head-color":"#343434","portfolio-info-color":"#b1b1b1","portfolio-badge-text-color":"#ffffff","portfolio-badge-background-color":"#3155a7","portfolio-thumbnail-title-color":"#ffffff","portfolio-thumbnail-info-color":"#cecece","portfolio-text-filter-color":"#aaaaaa","portfolio-text-filter-active-color":"#3155a7","portfolio-button-filter-text-color":"#838383","portfolio-button-filter-background-color":"#f1f1f1","portfolio-button-filter-text-active-color":"#ffffff","portfolio-button-filter-background-active-color":"#3155a7","price-table-background-color":"#f8f8f8","price-table-head-color":"#3e3e3e","price-table-head-top-gradient-color":"#525252","price-table-icon-color":"#ffffff","price-table-title-color":"#ffffff","price-table-caption-color":"#acacac","price-table-price-background-color":"#ebebeb","price-table-price-color":"#323232","price-table-price-suffix-color":"#acacac","price-table-price-button-color":"#ffffff","price-table-button-background-color":"#575757","price-table-button-background-top-gradient-color":"#414141","price-table-list-border-color":"#e5e5e5","price-table-active-head-color":"#3155a7","price-table-active-head-top-gradient-color":"#4c67a5","price-table-active-icon-color":"#ffffff","price-table-active-title-color":"#ffffff","price-table-active-caption-color":"#ffdcd1","price-table-active-price-background-color":"#ffffff","price-table-active-price-color":"#323232","price-table-active-price-suffix-color":"#acacac","price-table-active-price-button-color":"#ffffff","price-table-active-button-background-color":"#3155a7","price-table-active-button-background-top-gradient-color":"#4c67a5","accordion-normal-icon-color":"#191919","accordion-normal-title-head-color":"#191919","accordion-normal-title-color":"#191919","accordion-normal-icon-background-color":"#f3f3f3","accordion-icon-color":"#191919","accordion-title-head-color":"#191919","accordion-title-color":"#191919","accordion-title-background-color":"#f3f3f3","accordion-icon-active-color":"#191919","accordion-title-active-color":"#191919","accordion-title-background-active-color":"#f3f3f3","audio-background-color":"#e7e7e7","audio-text-color":"#202020","audio-content-background-color":"#afafaf","audio-content-progress-color":"#3155a7","audio-volume-background-color":"#afafaf","audio-volume-progress-color":"#646464","alert-box-item-background-color":"#ef5e68","alert-box-item-border-color":"#cd515a","alert-box-item-content-color":"#ffffff","alert-box-item-title-color":"#ffffff","blockquote-text-color":"#777777","blockquote-background-color":"#f5f5f5","blockquote-border-color":"#e2e2e2","blockquote-item-icon-color":"#4e4e4e","blockquote-item-content-color":"#4e4e4e","button-text-color":"#ffffff","button-text-hover-color":"#ffffff","button-background-color":"#3155a7","button-background-hover-color":"#2F2F2F","button-border-color":"#383838","button-border-hover-color":"#000000","button-gradient-background-color":"#3155a7","button-top-gradient-background-color":"#4361a5","call-to-action-title-color":"#2c2c2c","call-to-action-caption-color":"#535353","counter-item-top-text-color":"#828282","counter-item-top-icon-color":"#393939","counter-item-number-color":"#393939","counter-item-divider-color":"#393939","counter-item-bottom-text-color":"#393939","column-service-icon-color":"#9d9d9d","column-service-icon-background":"#f3f3f3","column-service-title-color":"#383838","column-service-caption-color":"#747474","dropdown-tab-head-background":"#3155a7","dropdown-tab-head-text":"#252525","flipbox-background-color":"#2d9bea","flipbox-border-color":"#2a80be","flipbox-icon-color":"#ffffff","flipbox-title-color":"#ffffff","flipbox-caption-color":"#ffffff","flipbox-content-color":"#ffffff","gallery-overlay-title":"#ffffff","gallery-overlay-caption":"#cecece","image-overlay-background-color":"#000000","image-overlay-icon-color":"#ffffff","image-overlay-icon-background":"#ffffff","image-item-border-color":"#000000","item-title-color":"#343434","item-title-caption-color":"#747474","item-title-link-color":"#747474","icon-list-item-icon-color":"#222222","icon-list-item-icon-background-color":"#f3f3f3","opening-hour-day-color":"#a5a5a5","opening-hour-open-color":"#262626","opening-hour-close-color":"#c8c8c8","opening-hour-icon-color":"#8a8989","opening-hour-divider-color":"#a6a6a6","personnel-grid-title-color":"#383838","personnel-grid-position-color":"#888888","personnel-grid-divider-color":"#cecece","personnel-grid-frame-color":"#f9f9f9","personnel-modern-title-color":"#ffffff","personnel-modern-position-color":"#ffffff","promo-box-item-title-color":"#383838","promo-box-content-border-color":"#e8e7e7","post-slider-title-color":"#ffffff","post-slider-info-color":"#c5c5c5","skill-bar-title-color":"#505050","skill-bar-icon-color":"#616161","skill-bar-background-color":"#f3f3f3","skill-bar-progress-color":"#3155a7","slider-outer-navigation-color":"#a7a7a7","slider-outer-navigation-background-color":"#f1f1f1","slider-control-navigation-color":"#8a8a8a","social-share-icon-color":"#202020","social-share-divider-color":"#e5e5e5","social-share-text-color":"#202020","stunning-text-title-color":"#747474","stunning-text-caption-color":"#383838","tab-title-color":"#8d8d8d","tab-title-background-color":"#f7f7f7","tab-title-border-color":"#ebebeb","tab-title-hover-bar-color":"#3155a7","tab-title-active-color":"#464646","tab-title-active-background-color":"#ffffff","table-head-background-color":"#3155a7","table-head-text-color":"#ffffff","table-odd-background-color":"#f9f9f9","table-odd-text-color":"#949494","table-even-background":"#f3f3f3","table-even-text":"#949494","testimonial-title-color":"#232323","testimonial-content-color":"#707070","testimonial-author-color":"#3b3b3b","testimonial-rating-color":"#ffa127","testimonial-position-color":"#3b3b3b","testimonial-quote-color":"#282828","title-item-title-color":"#383838","title-item-caption-color":"#747474","woocommerce-theme-color":"#3155a7","woocommerce-price-color":"#3155a7","woocommerce-price-linethrough-color":"#949494","woocommerce-button-background-hover-color":"#3155a7","woocommerce-button-text-color":"#ffffff","woocommerce-button-text-hover-color":"#ffffff","woocommerce-input-background-color":"#f3f3f3","product-item-title-color":"#191919","product-item-title-hover-color":"#434343","view-detail-text-color":"#ffffff","view-detail-background-color":"#000000","add-to-cart-text-color":"#ffffff","add-to-cart-background-color":"#3155a7","widget-price-filter-bar-background-color":"#e6e6e6","widget-price-filter-range-color":"#1e3875","widget-price-filter-handle-color":"#3155a7","skin":[{"name":"Dark","title":"#ffffff","title-hover":"","caption":"#d3d3d3","content":"#d6d6d6","icon":"#e5e5e5","link":"#ffffff","link-hover":"#bfbfbf","divider":"#a3a3a3","border":"#a0a0a0","element-background":"#000000","element-content":"#e5e5e5","button-text":"","button-text-hover":"","button-background":"#212121","button-background-hover":"","button-border-color":"","button-border-hover-color":""},{"name":"Dark Port","title":"#ffffff","title-hover":"","caption":"#ffffff","content":"#ffffff","icon":"#ffffff","link":"","link-hover":"","divider":"","border":"","element-background":"#ffffff","element-content":"#ffffff","button-text":"","button-text-hover":"","button-background":"#212121","button-background-hover":"#212121","button-border-color":"","button-border-hover-color":""},{"name":"Purple","title":"","title-hover":"","caption":"","content":"#abb1ff","icon":"","link":"","link-hover":"","divider":"","border":"","element-background":"","element-content":"","button-text":"","button-text-hover":"","button-background":"","button-background-hover":"","button-border-color":"","button-border-hover-color":""},{"name":"Red Dark","title":"","title-hover":"","caption":"","content":"#d0888b","icon":"","link":"","link-hover":"","divider":"","border":"","element-background":"","element-content":"","button-text":"","button-text-hover":"","button-background":"","button-background-hover":"","button-border-color":"","button-border-hover-color":""},{"name":"Port Carousel","title":"","title-hover":"","caption":"","content":"","icon":"#6d6d6d","link":"","link-hover":"","divider":"","border":"","element-background":"","element-content":"","button-text":"","button-text-hover":"","button-background":"","button-background-hover":"","button-border-color":"","button-border-hover-color":""},{"name":"About Orange","title":"#ffffff","title-hover":"","caption":"#ffffff","content":"#ff4800","icon":"","link":"","link-hover":"","divider":"","border":"","element-background":"","element-content":"","button-text":"","button-text-hover":"","button-background":"","button-background-hover":"","button-border-color":"","button-border-hover-color":""},{"name":"Contact form white","title":"","title-hover":"","caption":"","content":"","icon":"","link":"","link-hover":"","divider":"","border":"","element-background":"#ffffff","element-content":"","button-text":"","button-text-hover":"","button-background":"","button-background-hover":"","button-border-color":"","button-border-hover-color":""},{"name":"Contact form grey","title":"","title-hover":"","caption":"","content":"","icon":"","link":"","link-hover":"","divider":"","border":"","element-background":"#ffffff","element-content":"#7f7f7f","button-text":"","button-text-hover":"","button-background":"#81ca41","button-background-hover":"","button-border-color":"","button-border-hover-color":""},{"name":"Purple Counter","title":"#ffffff","title-hover":"","caption":"#9bb6f3","content":"#9bb6f3","icon":"#ffffff","link":"","link-hover":"","divider":"","border":"","element-background":"","element-content":"","button-text":"","button-text-hover":"","button-background":"","button-background-hover":"","button-border-color":"","button-border-hover-color":""},{"name":"CTA Purple","title":"#ffffff","title-hover":"","caption":"#aac1f6","content":"#aac1f6","icon":"","link":"","link-hover":"","divider":"","border":"","element-background":"","element-content":"","button-text":"#ffffff","button-text-hover":"","button-background":"#81ca41","button-background-hover":"","button-border-color":"","button-border-hover-color":""},{"name":"CTA HP3","title":"#ffffff","title-hover":"","caption":"#ffffff","content":"#ffffff","icon":"","link":"","link-hover":"","divider":"","border":"","element-background":"","element-content":"","button-text":"","button-text-hover":"","button-background":"#43a351","button-background-hover":"","button-border-color":"","button-border-hover-color":""},{"name":"HP3 Service","title":"#ffffff","title-hover":"","caption":"#c9fed1","content":"#c9fed1","icon":"","link":"","link-hover":"","divider":"","border":"","element-background":"","element-content":"","button-text":"#383838","button-text-hover":"#383838","button-background":"#ffffff","button-background-hover":"","button-border-color":"","button-border-hover-color":""},{"name":"Contact form green","title":"#ffffff","title-hover":"","caption":"","content":"","icon":"","link":"","link-hover":"","divider":"","border":"","element-background":"#ffffff","element-content":"#b7b7b7","button-text":"#ffffff","button-text-hover":"","button-background":"#2c2c2c","button-background-hover":"#43a351","button-border-color":"","button-border-hover-color":""},{"name":"Hp2 Blue content","title":"","title-hover":"","caption":"","content":"#3155a7","icon":"","link":"","link-hover":"","divider":"","border":"","element-background":"","element-content":"","button-text":"","button-text-hover":"","button-background":"","button-background-hover":"","button-border-color":"","button-border-hover-color":""}]},"seocrawler_plugin":{"enable-srcset":"enable","lightbox":"ilightbox","ilightbox-skin":"dark","link-to-lightbox":"enable","additional-css":"","additional-mobile-css":"","additional-head-script":"","additional-script":"","enable-maintenance":"disable","maintenance-page":"2","enable-preload":"disable","preload-image":"","thumbnail-sizing":[{"name":"Personnel Thumbnail","width":"700","height":"500","hard-crop":""},{"name":"Portfolio Thumbnail","width":"700","height":"450","hard-crop":""},{"name":"Portfolio Thumbnail Portrait","width":"700","height":"660","hard-crop":""},{"name":"Portfolio Thumbnail Portrait 2","width":"600","height":"800","hard-crop":""},{"name":"Large Landscape ","width":"1550","height":"700","hard-crop":""},{"name":"Portfolio Side Description Large","width":"900","height":"500","hard-crop":""},{"name":"Blog Full Thumbnail","width":"1100","height":"490","hard-crop":""},{"name":"Blog Column Thumbnail","width":"700","height":"430","hard-crop":""},{"name":"Personnel Square","width":"600","height":"600","hard-crop":""},{"name":"Personnel Thumbnail","width":"500","height":"655","hard-crop":""}]}}'
				),
				'seocrawler-demo3' => array(
					'title' => esc_html__('SEO Crawler - Demo 3', 'seocrawler'),
					'url' => 'http://demo.goodlayers.com/seocrawler/demo3',
					'xml' => get_template_directory() . '/admin/function/files/seocrawler-demo3.xml',
					'page' => 4952,
					'menu' => array('main_menu' => 27, 'mobile_menu' => 27),
					'widget' => '{"gdlrcst_sidebar_name":[{"name":"Elements","id":"elements"},{"name":"Blog","id":"blog"},{"name":"Blog Left","id":"blog-left"},{"name":"Blog Right","id":"blog-right"},{"name":"Shop","id":"shop"}],"sidebars_widgets":{"wp_inactive_widgets":["nav_menu-1","nav_menu-2","text-6"],"gdlr-core-sidebar-preset":["search-2","recent-posts-2","recent-comments-2","archives-2","categories-2","meta-2"],"footer-1":["text-1"],"footer-2":["text-2"],"footer-3":["nav_menu-3"],"footer-4":["text-7","nav_menu-4"],"elements":[],"blog":["text-3","gdlr-core-recent-portfolio-widget-2","recent-comments-3","tag_cloud-1"],"blog-left":["search-3","text-4","recent-posts-4","gdlr-core-portfolio-slider-widget-1"],"blog-right":["text-5","recent-comments-4","tag_cloud-2"],"shop":[],"array_version":3},"widget_archives":{"2":{"title":"","count":0,"dropdown":0},"_multiwidget":1},"widget_calendar":{"_multiwidget":1},"widget_categories":{"2":{"title":"","count":0,"hierarchical":0,"dropdown":0},"_multiwidget":1},"widget_gdlr-core-portfolio-slider-widget":{"1":{"title":"Recent Works","category":"","num-fetch":"3","thumbnail-size":"Frame Landscape 2"},"_multiwidget":1},"widget_gdlr-core-post-slider-widget":{"_multiwidget":1},"widget_gdlr-core-recent-portfolio-widget":{"2":{"title":"Recent Works","category":"","num-fetch":"9"},"_multiwidget":1},"widget_gdlr-core-recent-post-widget":{"_multiwidget":1},"widget_gdlr-core-twitter-widget":{"_multiwidget":1},"widget_media_audio":{"_multiwidget":1},"widget_media_image":{"_multiwidget":1},"widget_media_video":{"_multiwidget":1},"widget_meta":{"2":{"title":""},"_multiwidget":1},"widget_nav_menu":{"1":{"title":"Market Sectors","nav_menu":69},"2":{"title":"Useful Links","nav_menu":70},"3":{"title":"Our Services","nav_menu":28},"4":{"nav_menu":29},"_multiwidget":1},"widget_newsletterwidget":{"_multiwidget":1},"widget_newsletterwidgetminimal":{"_multiwidget":1},"widget_pages":{"_multiwidget":1},"widget_recent-comments":{"2":{"title":"","number":5},"3":{"title":"","number":5},"4":{"title":"","number":5},"_multiwidget":1},"widget_recent-posts":{"2":{"title":"","number":5},"4":{"title":"Recent Posts","number":5,"show_date":false},"_multiwidget":1},"widget_rev-slider-widget":{"_multiwidget":1},"widget_rss":{"1":[],"_multiwidget":1},"widget_search":{"2":{"title":""},"3":{"title":""},"_multiwidget":1},"widget_tag_cloud":{"1":{"title":"Tag Cloud","taxonomy":"post_tag"},"2":{"title":"Tag Cloud","taxonomy":"post_tag"},"_multiwidget":1},"widget_text":{"1":{"title":"About Us","text":"<span style=\"font-size: 14px; color: #ababab;\">Far far away, behind the word mountains, far from the countries Vokalia and Consonantia, there live the blind texts.<\/span>\r\n\r\n[gdlr_core_space height=\"21px\"]\r\n<img src=\"http:\/\/demo.goodlayers.com\/seocrawler\/demo2\/wp-content\/uploads\/2017\/07\/logo-white.png\" alt=\"\" \/>","filter":"content"},"2":{"title":"Contact Info","text":"[gdlr_core_icon icon=\"fa fa-location-arrow\" size=\"16px\" color=\"#43a351\" margin-left=\"\" margin-right=\"10px\" ] 12 Main Street Pt. London\r\n[gdlr_core_space height=\"-9px\"]\r\n[gdlr_core_icon icon=\"fa fa-phone\" size=\"16px\" color=\"#43a351\" margin-left=\"\" margin-right=\"10px\" ] +1-3454-5678-77\r\n[gdlr_core_space height=\"-9px\"]\r\n[gdlr_core_icon icon=\"fa fa-envelope-open-o\" size=\"16px\" color=\"#43a351\" margin-left=\"\" margin-right=\"10px\" ] sales@goodlayers.com","filter":"content"},"3":{"title":"Text Widget","text":"Nulla vitae elit libero, a pharetra augue. Nulla vitae elit libero, a pharetra augue. Nulla vitae elit libero, a pharetra augue. Donec sed odio dui. Etiam porta sem malesuada.","filter":false},"4":{"title":"About Us","text":"Nulla vitae elit libero, a pharetra augue. Nulla vitae elit libero, a pharetra augue. Nulla vitae elit libero, a pharetra augue. Donec sed odio dui.","filter":false},"5":{"title":"Text Widget","text":"Nulla vitae elit libero, a pharetra augue. Nulla vitae elit libero, a pharetra augue. Nulla vitae elit libero, a pharetra augue. Donec sed odio dui. Etiam porta sem malesuada.","filter":false},"6":{"title":"","text":"[gdlr_core_button button-text=\"Get A Quote\" border-radius=\"3px\" background-color=\"#222\" button-background=\"solid\" button-link=\"http:\/\/demo.goodlayers.com\/realfactory\/contact\/\" button-link-target=\"_parent\" margin-right=\"20px\" ]","filter":false},"7":{"title":"","text":"[gdlr_core_space height=\"5px\"]","filter":"content"},"_multiwidget":1},"widget_woocommerce_layered_nav":{"_multiwidget":1},"widget_woocommerce_layered_nav_filters":{"_multiwidget":1},"widget_woocommerce_price_filter":{"2":{"title":"Filter by price"},"_multiwidget":1},"widget_woocommerce_product_categories":{"2":{"title":"Product categories","orderby":"name","dropdown":0,"count":0,"hierarchical":1,"show_children_only":0,"hide_empty":0},"_multiwidget":1},"widget_woocommerce_product_search":{"_multiwidget":1},"widget_woocommerce_product_tag_cloud":{"_multiwidget":1},"widget_woocommerce_products":{"_multiwidget":1},"widget_woocommerce_rating_filter":{"_multiwidget":1},"widget_woocommerce_recent_reviews":{"_multiwidget":1},"widget_woocommerce_recently_viewed_products":{"_multiwidget":1},"widget_woocommerce_top_rated_products":{"_multiwidget":1},"widget_woocommerce_widget_cart":{"2":{"title":"Cart","hide_if_empty":0},"_multiwidget":1},"widget_wpgmp_google_map_widget_class":{"_multiwidget":1}}',
					'theme-option' => '{"seocrawler_general":{"layout":"boxed","boxed-layout-top-margin":"50px","body-margin":"0px","background-type":"color","background-image":"","background-image-opacity":"100","background-pattern":"pattern-1","enable-boxed-border":"disable","item-padding":"20px","container-width":"1180px","container-padding":"30px","sidebar-width":"20","both-sidebar-width":"15","enable-top-bar":"enable","enable-top-bar-on-mobile":"enable","top-bar-width":"full","top-bar-width-pixel":"1140px","top-bar-full-side-padding":"15px","top-bar-left-text":"","top-bar-right-text":"[gdlr_core_icon icon=\"fa fa-envelope-open-o\" size=\"16px\" color=\"#ffffff\" margin-left=\"\" margin-right=\"10px\" ] <strong>Email<\/strong>  Sales@GoodLayers.com [gdlr_core_icon icon=\"fa fa-phone\" size=\"16px\" color=\"#ffffff\" margin-left=\"20px\" margin-right=\"10px\" ] <strong>Call Now!<\/strong>  +1-3454-5678-77","top-bar-top-padding":"17px","top-bar-bottom-padding":"17px","top-bar-text-size":"15px","top-bar-bottom-border":"0px","enable-top-bar-social":"enable","top-bar-social-delicious":"","top-bar-social-email":"","top-bar-social-deviantart":"","top-bar-social-digg":"","top-bar-social-facebook":"#","top-bar-social-flickr":"","top-bar-social-google-plus":"#","top-bar-social-lastfm":"","top-bar-social-linkedin":"#","top-bar-social-pinterest":"#","top-bar-social-rss":"","top-bar-social-skype":"","top-bar-social-stumbleupon":"","top-bar-social-tumblr":"","top-bar-social-twitter":"#","top-bar-social-vimeo":"#","top-bar-social-youtube":"","top-bar-social-instagram":"","top-bar-social-snapchat":"","header-style":"plain","header-plain-style":"splitted-menu","header-plain-bottom-border":"0px","header-bar-navigation-align":"center","header-background-style":"solid","top-bar-background-opacity":"100","header-background-opacity":"0","navigation-background-opacity":"50","header-boxed-style":"menu-right","boxed-top-bar-background-opacity":"0","boxed-top-bar-background-extend":"0px","boxed-header-top-margin":"0px","header-side-style":"top-left","header-side-align":"left","header-side-toggle-style":"left","header-side-toggle-menu-type":"overlay","header-side-toggle-display-logo":"enable","header-width":"boxed","header-width-pixel":"1140px","header-full-side-padding":"15px","boxed-header-frame-radius":"3px","boxed-header-content-padding":"30px","navigation-text-top-margin":"36px","navigation-text-top-margin-boxed":"0px","navigation-text-side-spacing":"20px","navigation-slide-bar":"enable","side-header-width-pixel":"340px","side-header-side-padding":"70px","navigation-text-top-spacing":"16px","logo-right-text":"","logo-right-text-top-padding":"30px","logo":"5041","mobile-logo":"","logo-top-padding":"45px","logo-bottom-padding":"41px","logo-left-padding":"","max-logo-width":"212px","main-navigation-top-padding":"33px","main-navigation-bottom-padding":"39px","main-navigation-item-right-padding":"0px","main-navigation-right-padding":"","enable-main-navigation-submenu-indicator":"disable","enable-main-navigation-search":"disable","enable-main-navigation-cart":"disable","enable-main-navigation-right-button":"enable","main-navigation-right-button-text":"Get a quote","main-navigation-right-button-link":"\/seocrawler\/demo3\/free-quote\/","main-navigation-right-button-link-target":"_self","right-menu-type":"right","right-menu-style":"hamburger","enable-main-navigation-sticky":"enable","enable-logo-on-main-navigation-sticky":"disable","fixed-navigation-max-logo-width":"150px","fixed-navigation-logo-top-padding":"23px","fixed-navigation-logo-bottom-padding":"20px","fixed-navigation-top-padding":"27px","fixed-navigation-bottom-padding":"27px","fixed-navigation-anchor-offset":"75px","default-title-style":"large","default-title-align":"center","default-title-top-padding":"93px","default-title-bottom-padding":"87px","default-page-caption-top-margin":"13px","default-title-font-transform":"none","default-title-font-size":"37px","default-title-font-weight":"","default-title-letter-spacing":"0px","default-caption-font-size":"16px","default-caption-font-weight":"","default-caption-letter-spacing":"0px","default-title-background-overlay-opacity":"0","default-title-background":"4561","default-portfolio-title-background":"","default-personnel-title-background":"","default-search-title-background":"","default-archive-title-background":"","default-404-background":"","default-404-background-opacity":"27","default-blog-title-style":"small","default-blog-title-top-padding":"93px","default-blog-title-bottom-padding":"87px","default-blog-feature-image":"title-background","default-blog-title-background-image":"","default-blog-title-background-overlay-opacity":"30","blog-sidebar":"none","blog-sidebar-left":"gdlr-core-sidebar-preset","blog-sidebar-right":"gdlr-core-sidebar-preset","blog-max-content-width":"900px","blog-thumbnail-size":"full","blog-date-feature":"enable","blog-date-feature-year":"disable","meta-option":["author","category","tag","comment-number"],"blog-author":"enable","blog-navigation":"enable","pagination-style":"round","pagination-align":"right","blog-social-share":"enable","blog-social-share-count":"enable","blog-social-facebook":"enable","blog-social-linkedin":"disable","blog-social-google-plus":"enable","blog-social-pinterest":"enable","blog-social-stumbleupon":"disable","blog-social-twitter":"enable","blog-social-email":"disable","archive-blog-sidebar":"right","archive-blog-sidebar-left":"gdlr-core-sidebar-preset","archive-blog-sidebar-right":"gdlr-core-sidebar-preset","archive-blog-style":"blog-full","archive-blog-full-alignment":"left","archive-thumbnail-size":"full","archive-show-thumbnail":"enable","archive-column-size":"20","archive-excerpt":"specify-number","archive-excerpt-number":"55","archive-date-feature":"enable","archive-meta-option":["date","author","category"],"archive-show-read-more":"enable","woocommerce-archive-sidebar":"right","woocommerce-archive-sidebar-left":"gdlr-core-sidebar-preset","woocommerce-archive-sidebar-right":"shop","woocommerce-archive-column-size":"30","woocommerce-archive-thumbnail":"Portfolio Thumbnail Portrait","woocommerce-related-product-column-size":"15","woocommerce-related-product-num-fetch":"4","woocommerce-related-product-thumbnail":"Blog Column Thumbnail","portfolio-slug":"portfolio","portfolio-category-slug":"portfolio_category","portfolio-tag-slug":"portfolio_tag","enable-single-portfolio-navigation":"enable","enable-single-portfolio-navigation-in-same-tag":"enable","portfolio-icon-hover-link":"icon_link_alt","portfolio-icon-hover-video":"icon_film","portfolio-icon-hover-image":"icon_zoom-in_alt","portfolio-icon-hover-size":"22px","enable-related-portfolio":"enable","related-portfolio-style":"grid","related-portfolio-column-size":"20","related-portfolio-num-fetch":"3","related-portfolio-thumbnail-size":"Portfolio Thumbnail","related-portfolio-num-excerpt":"20","archive-portfolio-sidebar":"none","archive-portfolio-sidebar-left":"gdlr-core-sidebar-preset","archive-portfolio-sidebar-right":"gdlr-core-sidebar-preset","archive-portfolio-style":"medium","archive-portfolio-thumbnail-size":"full","archive-portfolio-grid-text-align":"left","archive-portfolio-grid-style":"normal","archive-enable-portfolio-tag":"enable","archive-portfolio-medium-size":"small","archive-portfolio-medium-style":"switch","archive-portfolio-hover":"icon","archive-portfolio-column-size":"20","archive-portfolio-excerpt":"specify-number","archive-portfolio-excerpt-number":"55","personnel-slug":"personnel","personnel-category-slug":"personnel_category","fixed-footer":"disable","enable-footer":"enable","footer-top-padding":"70px","footer-bottom-padding":"50px","footer-style":"footer-2","enable-copyright":"enable","copyright-style":"left-right","copyright-top-padding":"30px","copyright-bottom-padding":"30px","copyright-font-letter-spacing":"0px","copyright-text-transform":"none","copyright-text":"","copyright-left":"[gdlr_core_icon icon=\"fa fa-facebook\" size=\"16px\" color=\"#ffffff\" margin-left=\"\" margin-right=\"20px\" link=\"#\" link-target=\"_blank\"] [gdlr_core_icon icon=\"fa fa-twitter\" size=\"16px\" color=\"#ffffff\" margin-left=\"\" margin-right=\"20px\" link=\"#\" link-target=\"_blank\"] [gdlr_core_icon icon=\"fa fa-linkedin\" size=\"16px\" color=\"#ffffff\" margin-left=\"\" margin-right=\"20px\" link=\"#\" link-target=\"_blank\"] [gdlr_core_icon icon=\"fa fa-pinterest-p\" size=\"16px\" color=\"#ffffff\" margin-left=\"\" margin-right=\"20px\" link=\"#\" link-target=\"_blank\"] [gdlr_core_icon icon=\"fa fa-vimeo\" size=\"16px\" color=\"#ffffff\" margin-left=\"\" margin-right=\"20px\" link=\"#\" link-target=\"_blank\"]","copyright-right":"Copyright 2017 GoodLayers, All Right Reserved","enable-back-to-top":"enable","related-portfolio-enable-tag":"disable","related-portfolio-thumbnail-hover":"title","related-portfolio-title-font-size":"15px","related-portfolio-title-font-weight":"500","boxed-layout-border-radius":"5px"},"seocrawler_typography":{"heading-font":"Poppins","navigation-font":"Nunito","content-font":"Poppins","info-font":"Poppins","blog-info-font":"Poppins","quote-font":"Droid Serif","additional-font":"Georgia, serif","additional-font2":"Georgia, serif","h1-font-size":"52px","h2-font-size":"48px","h3-font-size":"36px","h4-font-size":"28px","h5-font-size":"22px","h6-font-size":"18px","navigation-font-size":"14px","navigation-font-weight":"400","navigation-font-letter-spacing":"0px","navigation-text-transform":"uppercase","content-font-size":"16px","content-line-height":"1.7","testimonial-font":"Droid Serif"},"seocrawler_color":{"page-preload-background-color":"#ffffff","top-bar-background-color":"#2c2c2c","top-bar-bottom-border-color":"#ffffff","top-bar-text-color":"#ffffff","top-bar-link-color":"#ffffff","top-bar-link-hover-color":"#ffffff","top-bar-social-color":"#43a351","top-bar-social-hover-color":"#000000","header-background-color":"#ffffff","header-plain-bottom-border-color":"#e8e8e8","navigation-bar-background-color":"#f4f4f4","navigation-bar-top-border-color":"#e8e8e8","navigation-slide-bar-color":"#43a351","logo-background-color":"#ffffff","navigation-bar-right-icon-color":"#2d2d2d","woocommerce-cart-icon-number-background":"#43a351","woocommerce-cart-icon-number-color":"#ffffff","secondary-menu-icon-color":"#ffffff","secondary-menu-border-color":"#dddddd","search-overlay-background-color":"#000000","top-cart-background-color":"#303030","top-cart-text-color":"#b5b5b5","top-cart-view-cart-color":"#ffffff","top-cart-checkout-color":"#43a351","breadcrumbs-text-color":"#c0c0c0","breadcrumbs-text-active-color":"#777777","main-menu-text-color":"#999999","main-menu-text-hover-color":"#333333","sub-menu-background-color":"#f3f3f3","sub-menu-text-color":"#606060","sub-menu-text-hover-color":"#43a351","sub-menu-text-hover-background-color":"#ffffff","sub-mega-menu-title-color":"#353535","sub-mega-menu-divider-color":"#e2e2e2","side-menu-text-color":"#979797","side-menu-text-hover-color":"#ffffff","side-menu-background-color":"#1f1f1f","side-menu-border-color":"#626262","overlay-menu-background-color":"#000000","overlay-menu-border-color":"#424242","overlay-menu-text-color":"#ffffff","overlay-menu-text-hover-color":"#a8a8a8","anchor-bullet-background-color":"#777777","anchor-bullet-background-active-color":"#ffffff","navigation-right-button-text-color":"#ffffff","navigation-right-button-background-color":"#43a351","navigation-right-button-border-color":"#333333","navigation-right-button-text-hover-color":"#ffffff","navigation-right-button-background-hover-color":"#282828","navigation-right-button-border-hover-color":"#555555","body-background-color":"#cccccc","container-background-color":"#ffffff","page-title-color":"#ffffff","page-caption-color":"#ffffff","page-title-background-overlay-color":"#000000","body-content-color":"#6e6e6e","heading-color":"#383838","link-color":"#43a351","link-hover-color":"#333333","divider-color":"#e6e6e6","input-box-background-color":"#f3f3f3","input-box-border-color":"#d7d7d7","input-box-text-color":"#7c7c7c","input-box-placeholder-color":"#7c7c7c","404-content-background-color":"#23618e","404-head-color":"#ffffff","404-title-color":"#ffffff","404-caption-color":"#c3e7ff","404-input-background-color":"#000000","404-input-text-color":"#ffffff","404-back-to-home-color":"#ffffff","sidebar-title-color":"#383838","sidebar-link-color":"#484848","sidebar-link-hover-color":"#323232","recent-post-widget-info-icon-color":"#9c9c9c","recent-post-widget-info-link-color":"#a0a0a0","post-slider-widget-title-color":"#ffffff","post-slider-widget-info-color":"#9c9c9c","search-box-text-color":"#b5b5b5","search-box-border-color":"#e0e0e0","search-box-icon-color":"#c7c7c7","twitter-widget-icon-color":"#303030","twitter-widget-date-color":"#b5b5b5","footer-background-color":"#202020","footer-title-color":"#ffffff","footer-content-color":"#ffffff","footer-link-color":"#43a351","footer-link-hover-color":"#ffffff","footer-divider-color":"#303030","copyright-background-color":"#181818","copyright-text-color":"#838383","copyright-link-color":"#838383","copyright-link-hover-color":"#838383","back-to-top-background-color":"#dbdbdb","back-to-top-text-color":"#313131","single-blog-title-color":"#ffffff","single-blog-info-color":"#ffffff","single-blog-date-day-color":"#ffffff","single-blog-date-month-color":"#b1b1b1","single-blog-divider-color":"#ffffff","single-blog-title-background-overlay-color":"#000000","single-blog-author-title-color":"#464646","single-blog-author-caption-color":"#b1b1b1","single-blog-navigation-color":"#bcbcbc","single-blog-comment-title-color":"#464646","single-blog-comment-background-color":"#f9f9f9","single-blog-comment-reply-color":"#bcbcbc","single-blog-comment-time-color":"#b1b1b1","blog-title-color":"#343434","blog-title-hover-color":"#343434","blog-sticky-banner-color":"#444444","blog-sticky-banner-background":"#f3f3f3","blog-info-color":"#989898","blog-date-day-color":"#353535","blog-date-month-color":"#8a8a8a","blog-frame-background-color":"#ffffff","blog-modern-text-color":"#ffffff","blog-aside-background-color":"#43a351","blog-aside-text-color":"#ffffff","pagination-background-color":"#e8e8e8","pagination-text-color":"#929292","pagination-background-hover-color":"#43a351","pagination-text-hover-color":"#ffffff","pagination-plain-color":"#b4b4b4","pagination-plain-hover-color":"#424242","single-portfolio-nav-color":"#bcbcbc","portfolio-frame-background-color":"#ffffff","portfolio-title-color":"#3a3a3a","portfolio-info-head-color":"#343434","portfolio-info-color":"#b1b1b1","portfolio-badge-text-color":"#ffffff","portfolio-badge-background-color":"#43a351","portfolio-thumbnail-title-color":"#ffffff","portfolio-thumbnail-info-color":"#cecece","portfolio-text-filter-color":"#aaaaaa","portfolio-text-filter-active-color":"#43a351","portfolio-button-filter-text-color":"#838383","portfolio-button-filter-background-color":"#f1f1f1","portfolio-button-filter-text-active-color":"#ffffff","portfolio-button-filter-background-active-color":"#43a351","price-table-background-color":"#f8f8f8","price-table-head-color":"#3e3e3e","price-table-head-top-gradient-color":"#525252","price-table-icon-color":"#ffffff","price-table-title-color":"#ffffff","price-table-caption-color":"#acacac","price-table-price-background-color":"#ebebeb","price-table-price-color":"#323232","price-table-price-suffix-color":"#acacac","price-table-price-button-color":"#ffffff","price-table-button-background-color":"#575757","price-table-button-background-top-gradient-color":"#414141","price-table-list-border-color":"#e5e5e5","price-table-active-head-color":"#43a351","price-table-active-head-top-gradient-color":"#5ea368","price-table-active-icon-color":"#ffffff","price-table-active-title-color":"#ffffff","price-table-active-caption-color":"#a5d89e","price-table-active-price-background-color":"#ffffff","price-table-active-price-color":"#323232","price-table-active-price-suffix-color":"#acacac","price-table-active-price-button-color":"#ffffff","price-table-active-button-background-color":"#43a351","price-table-active-button-background-top-gradient-color":"#5da367","accordion-normal-icon-color":"#191919","accordion-normal-title-head-color":"#191919","accordion-normal-title-color":"#191919","accordion-normal-icon-background-color":"#f3f3f3","accordion-icon-color":"#191919","accordion-title-head-color":"#191919","accordion-title-color":"#191919","accordion-title-background-color":"#f3f3f3","accordion-icon-active-color":"#191919","accordion-title-active-color":"#191919","accordion-title-background-active-color":"#f3f3f3","audio-background-color":"#e7e7e7","audio-text-color":"#202020","audio-content-background-color":"#afafaf","audio-content-progress-color":"#43a351","audio-volume-background-color":"#afafaf","audio-volume-progress-color":"#646464","alert-box-item-background-color":"#ef5e68","alert-box-item-border-color":"#cd515a","alert-box-item-content-color":"#ffffff","alert-box-item-title-color":"#ffffff","blockquote-text-color":"#777777","blockquote-background-color":"#f5f5f5","blockquote-border-color":"#e2e2e2","blockquote-item-icon-color":"#4e4e4e","blockquote-item-content-color":"#4e4e4e","button-text-color":"#ffffff","button-text-hover-color":"#ffffff","button-background-color":"#43a351","button-background-hover-color":"#2F2F2F","button-border-color":"#383838","button-border-hover-color":"#000000","button-gradient-background-color":"#43a351","button-top-gradient-background-color":"#5ea368","call-to-action-title-color":"#2c2c2c","call-to-action-caption-color":"#535353","counter-item-top-text-color":"#828282","counter-item-top-icon-color":"#393939","counter-item-number-color":"#393939","counter-item-divider-color":"#393939","counter-item-bottom-text-color":"#393939","column-service-icon-color":"#9d9d9d","column-service-icon-background":"#f3f3f3","column-service-title-color":"#383838","column-service-caption-color":"#747474","dropdown-tab-head-background":"#43a351","dropdown-tab-head-text":"#252525","flipbox-background-color":"#2d9bea","flipbox-border-color":"#2a80be","flipbox-icon-color":"#ffffff","flipbox-title-color":"#ffffff","flipbox-caption-color":"#ffffff","flipbox-content-color":"#ffffff","gallery-overlay-title":"#ffffff","gallery-overlay-caption":"#cecece","image-overlay-background-color":"#000000","image-overlay-icon-color":"#ffffff","image-overlay-icon-background":"#ffffff","image-item-border-color":"#000000","item-title-color":"#343434","item-title-caption-color":"#747474","item-title-link-color":"#747474","icon-list-item-icon-color":"#222222","icon-list-item-icon-background-color":"#f3f3f3","opening-hour-day-color":"#a5a5a5","opening-hour-open-color":"#262626","opening-hour-close-color":"#c8c8c8","opening-hour-icon-color":"#8a8989","opening-hour-divider-color":"#a6a6a6","personnel-grid-title-color":"#383838","personnel-grid-position-color":"#888888","personnel-grid-divider-color":"#cecece","personnel-grid-frame-color":"#f9f9f9","personnel-modern-title-color":"#ffffff","personnel-modern-position-color":"#ffffff","promo-box-item-title-color":"#383838","promo-box-content-border-color":"#e8e7e7","post-slider-title-color":"#ffffff","post-slider-info-color":"#c5c5c5","skill-bar-title-color":"#505050","skill-bar-icon-color":"#616161","skill-bar-background-color":"#f3f3f3","skill-bar-progress-color":"#43a351","slider-outer-navigation-color":"#a7a7a7","slider-outer-navigation-background-color":"#f1f1f1","slider-control-navigation-color":"#8a8a8a","social-share-icon-color":"#202020","social-share-divider-color":"#e5e5e5","social-share-text-color":"#202020","stunning-text-title-color":"#747474","stunning-text-caption-color":"#383838","tab-title-color":"#8d8d8d","tab-title-background-color":"#f7f7f7","tab-title-border-color":"#ebebeb","tab-title-hover-bar-color":"#43a351","tab-title-active-color":"#464646","tab-title-active-background-color":"#ffffff","table-head-background-color":"#43a351","table-head-text-color":"#ffffff","table-odd-background-color":"#f9f9f9","table-odd-text-color":"#949494","table-even-background":"#f3f3f3","table-even-text":"#949494","testimonial-title-color":"#232323","testimonial-content-color":"#707070","testimonial-author-color":"#3b3b3b","testimonial-rating-color":"#ffa127","testimonial-position-color":"#3b3b3b","testimonial-quote-color":"#282828","title-item-title-color":"#383838","title-item-caption-color":"#747474","woocommerce-theme-color":"#43a351","woocommerce-price-color":"#43a351","woocommerce-price-linethrough-color":"#949494","woocommerce-button-background-hover-color":"#43a351","woocommerce-button-text-color":"#ffffff","woocommerce-button-text-hover-color":"#ffffff","woocommerce-input-background-color":"#f3f3f3","product-item-title-color":"#191919","product-item-title-hover-color":"#434343","view-detail-text-color":"#ffffff","view-detail-background-color":"#000000","add-to-cart-text-color":"#ffffff","add-to-cart-background-color":"#43a351","widget-price-filter-bar-background-color":"#e6e6e6","widget-price-filter-range-color":"#337f3a","widget-price-filter-handle-color":"#43a351","skin":[{"name":"Dark","title":"#ffffff","title-hover":"","caption":"#d3d3d3","content":"#d6d6d6","icon":"#e5e5e5","link":"#ffffff","link-hover":"#bfbfbf","divider":"#a3a3a3","border":"#a0a0a0","element-background":"#000000","element-content":"#e5e5e5","button-text":"","button-text-hover":"","button-background":"#212121","button-background-hover":"","button-border-color":"","button-border-hover-color":""},{"name":"Dark Port","title":"#ffffff","title-hover":"","caption":"#ffffff","content":"#ffffff","icon":"#ffffff","link":"","link-hover":"","divider":"","border":"","element-background":"#ffffff","element-content":"#ffffff","button-text":"","button-text-hover":"","button-background":"#212121","button-background-hover":"#212121","button-border-color":"","button-border-hover-color":""},{"name":"Purple","title":"","title-hover":"","caption":"","content":"#abb1ff","icon":"","link":"","link-hover":"","divider":"","border":"","element-background":"","element-content":"","button-text":"","button-text-hover":"","button-background":"","button-background-hover":"","button-border-color":"","button-border-hover-color":""},{"name":"Red Dark","title":"","title-hover":"","caption":"","content":"#d0888b","icon":"","link":"","link-hover":"","divider":"","border":"","element-background":"","element-content":"","button-text":"","button-text-hover":"","button-background":"","button-background-hover":"","button-border-color":"","button-border-hover-color":""},{"name":"Port Carousel","title":"","title-hover":"","caption":"","content":"","icon":"#6d6d6d","link":"","link-hover":"","divider":"","border":"","element-background":"","element-content":"","button-text":"","button-text-hover":"","button-background":"","button-background-hover":"","button-border-color":"","button-border-hover-color":""},{"name":"About Orange","title":"#ffffff","title-hover":"","caption":"#ffffff","content":"#ff4800","icon":"","link":"","link-hover":"","divider":"","border":"","element-background":"","element-content":"","button-text":"","button-text-hover":"","button-background":"","button-background-hover":"","button-border-color":"","button-border-hover-color":""},{"name":"Contact form white","title":"","title-hover":"","caption":"","content":"","icon":"","link":"","link-hover":"","divider":"","border":"","element-background":"#ffffff","element-content":"","button-text":"","button-text-hover":"","button-background":"","button-background-hover":"","button-border-color":"","button-border-hover-color":""},{"name":"Contact form grey","title":"","title-hover":"","caption":"","content":"","icon":"","link":"","link-hover":"","divider":"","border":"","element-background":"#ffffff","element-content":"#7f7f7f","button-text":"","button-text-hover":"","button-background":"#81ca41","button-background-hover":"","button-border-color":"","button-border-hover-color":""},{"name":"Purple Counter","title":"#ffffff","title-hover":"","caption":"#9bb6f3","content":"#9bb6f3","icon":"#ffffff","link":"","link-hover":"","divider":"","border":"","element-background":"","element-content":"","button-text":"","button-text-hover":"","button-background":"","button-background-hover":"","button-border-color":"","button-border-hover-color":""},{"name":"CTA Purple","title":"#ffffff","title-hover":"","caption":"#aac1f6","content":"#aac1f6","icon":"","link":"","link-hover":"","divider":"","border":"","element-background":"","element-content":"","button-text":"#ffffff","button-text-hover":"","button-background":"#81ca41","button-background-hover":"","button-border-color":"","button-border-hover-color":""},{"name":"CTA HP3","title":"#ffffff","title-hover":"","caption":"#ffffff","content":"#ffffff","icon":"","link":"","link-hover":"","divider":"","border":"","element-background":"","element-content":"","button-text":"","button-text-hover":"","button-background":"#43a351","button-background-hover":"","button-border-color":"","button-border-hover-color":""},{"name":"HP3 Service","title":"#ffffff","title-hover":"","caption":"#c9fed1","content":"#c9fed1","icon":"","link":"","link-hover":"","divider":"","border":"","element-background":"","element-content":"","button-text":"#383838","button-text-hover":"#383838","button-background":"#ffffff","button-background-hover":"","button-border-color":"","button-border-hover-color":""},{"name":"Contact form green","title":"#ffffff","title-hover":"","caption":"","content":"","icon":"","link":"","link-hover":"","divider":"","border":"","element-background":"#ffffff","element-content":"#b7b7b7","button-text":"#ffffff","button-text-hover":"","button-background":"#2c2c2c","button-background-hover":"#43a351","button-border-color":"","button-border-hover-color":""},{"name":"Hp2 Blue content","title":"","title-hover":"","caption":"","content":"#3155a7","icon":"","link":"","link-hover":"","divider":"","border":"","element-background":"","element-content":"","button-text":"","button-text-hover":"","button-background":"","button-background-hover":"","button-border-color":"","button-border-hover-color":""}]},"seocrawler_plugin":{"enable-srcset":"enable","lightbox":"ilightbox","ilightbox-skin":"dark","link-to-lightbox":"enable","additional-css":"","additional-mobile-css":"","additional-head-script":"","additional-script":"","enable-maintenance":"disable","maintenance-page":"2","enable-preload":"disable","preload-image":"","thumbnail-sizing":[{"name":"Personnel Thumbnail","width":"700","height":"500","hard-crop":""},{"name":"Portfolio Thumbnail","width":"700","height":"450","hard-crop":""},{"name":"Portfolio Thumbnail Portrait","width":"700","height":"660","hard-crop":""},{"name":"Portfolio Thumbnail Portrait 2","width":"600","height":"800","hard-crop":""},{"name":"Large Landscape ","width":"1550","height":"700","hard-crop":""},{"name":"Portfolio Side Description Large","width":"900","height":"500","hard-crop":""},{"name":"Blog Full Thumbnail","width":"1100","height":"490","hard-crop":""},{"name":"Blog Column Thumbnail","width":"700","height":"430","hard-crop":""},{"name":"Personnel Square","width":"600","height":"600","hard-crop":""},{"name":"Personnel Thumbnail","width":"500","height":"655","hard-crop":""}]}}'
				),
			);
		}
	}

	// add action when finish install plugins
	add_action('seocrawler_tgmpa_no_item_redirect', 'seocrawler_tgmpa_no_item_redirect');
	if( !function_exists('seocrawler_tgmpa_no_item_redirect') ){
		function seocrawler_tgmpa_no_item_redirect(){
			echo '<script type="text/javascript">';
			echo 'window.location = \'' . admin_url('admin.php?page=gdlr_core_getting_start') . '\';';
			echo '</script>';
		}
	}

	// install required plugin and redirect to getting start page
	add_action('after_switch_theme', 'seocrawler_getting_start_redirect'); 	
	if( !function_exists('seocrawler_getting_start_redirect') ){
		function seocrawler_getting_start_redirect(){

			$default_theme_option = '{"seocrawler_general":{"layout":"full","boxed-layout-top-margin":"0px","body-margin":"0px","background-type":"color","background-image":"","background-image-opacity":"100","background-pattern":"pattern-1","enable-boxed-border":"disable","item-padding":"20px","container-width":"1320px","container-padding":"40px","sidebar-width":"20","both-sidebar-width":"15","enable-top-bar":"disable","enable-top-bar-on-mobile":"disable","top-bar-width":"full","top-bar-width-pixel":"1140px","top-bar-full-side-padding":"10px","top-bar-left-text":"","top-bar-right-text":"","top-bar-top-padding":"22px","top-bar-bottom-padding":"22px","top-bar-text-size":"15px","top-bar-bottom-border":"0px","enable-top-bar-social":"enable","top-bar-social-delicious":"","top-bar-social-email":"","top-bar-social-deviantart":"","top-bar-social-digg":"","top-bar-social-facebook":"#","top-bar-social-flickr":"","top-bar-social-google-plus":"#","top-bar-social-lastfm":"","top-bar-social-linkedin":"#","top-bar-social-pinterest":"#","top-bar-social-rss":"","top-bar-social-skype":"","top-bar-social-stumbleupon":"","top-bar-social-tumblr":"","top-bar-social-twitter":"#","top-bar-social-vimeo":"","top-bar-social-youtube":"","top-bar-social-instagram":"","top-bar-social-snapchat":"","header-style":"plain","header-plain-style":"menu-right","header-plain-bottom-border":"0px","header-bar-navigation-align":"center","header-background-style":"transparent","top-bar-background-opacity":"100","header-background-opacity":"0","navigation-background-opacity":"50","header-boxed-style":"menu-right","boxed-top-bar-background-opacity":"0","boxed-top-bar-background-extend":"0px","boxed-header-top-margin":"0px","header-side-style":"top-left","header-side-align":"left","header-side-toggle-style":"left","header-side-toggle-menu-type":"overlay","header-side-toggle-display-logo":"enable","header-width":"boxed","header-width-pixel":"1140px","header-full-side-padding":"15px","boxed-header-frame-radius":"3px","boxed-header-content-padding":"30px","navigation-text-top-margin":"0px","navigation-text-top-margin-boxed":"0px","navigation-text-side-spacing":"18px","navigation-slide-bar":"enable","side-header-width-pixel":"340px","side-header-side-padding":"70px","navigation-text-top-spacing":"16px","logo-right-text":"","logo-right-text-top-padding":"30px","logo":"4559","mobile-logo":"","logo-top-padding":"46px","logo-bottom-padding":"20px","logo-left-padding":"","max-logo-width":"212px","main-navigation-top-padding":"54px","main-navigation-bottom-padding":"35px","main-navigation-item-right-padding":"0px","main-navigation-right-padding":"","enable-main-navigation-submenu-indicator":"disable","enable-main-navigation-search":"enable","enable-main-navigation-cart":"disable","enable-main-navigation-right-button":"enable","main-navigation-right-button-text":"Get a quote","main-navigation-right-button-link":"\/seocrawler\/free-quote\/","main-navigation-right-button-link-target":"_self","right-menu-type":"right","right-menu-style":"hamburger","enable-main-navigation-sticky":"disable","enable-logo-on-main-navigation-sticky":"enable","fixed-navigation-max-logo-width":"150px","fixed-navigation-logo-top-padding":"23px","fixed-navigation-logo-bottom-padding":"20px","fixed-navigation-top-padding":"27px","fixed-navigation-bottom-padding":"27px","fixed-navigation-anchor-offset":"75px","default-title-style":"large","default-title-align":"center","default-title-top-padding":"93px","default-title-bottom-padding":"87px","default-page-caption-top-margin":"13px","default-title-font-transform":"none","default-title-font-size":"37px","default-title-font-weight":"","default-title-letter-spacing":"0px","default-caption-font-size":"16px","default-caption-font-weight":"","default-caption-letter-spacing":"0px","default-title-background-overlay-opacity":"0","default-title-background":"4561","default-portfolio-title-background":"","default-personnel-title-background":"","default-search-title-background":"","default-archive-title-background":"","default-404-background":"","default-404-background-opacity":"27","default-blog-title-style":"small","default-blog-title-top-padding":"93px","default-blog-title-bottom-padding":"87px","default-blog-feature-image":"title-background","default-blog-title-background-image":"","default-blog-title-background-overlay-opacity":"30","blog-sidebar":"none","blog-sidebar-left":"gdlr-core-sidebar-preset","blog-sidebar-right":"gdlr-core-sidebar-preset","blog-max-content-width":"900px","blog-thumbnail-size":"full","blog-date-feature":"enable","blog-date-feature-year":"disable","meta-option":["author","category","tag","comment-number"],"blog-author":"enable","blog-navigation":"enable","pagination-style":"round","pagination-align":"right","blog-social-share":"enable","blog-social-share-count":"enable","blog-social-facebook":"enable","blog-social-linkedin":"disable","blog-social-google-plus":"enable","blog-social-pinterest":"enable","blog-social-stumbleupon":"disable","blog-social-twitter":"enable","blog-social-email":"disable","archive-blog-sidebar":"right","archive-blog-sidebar-left":"gdlr-core-sidebar-preset","archive-blog-sidebar-right":"gdlr-core-sidebar-preset","archive-blog-style":"blog-full","archive-blog-full-alignment":"left","archive-thumbnail-size":"full","archive-show-thumbnail":"enable","archive-column-size":"20","archive-excerpt":"specify-number","archive-excerpt-number":"55","archive-date-feature":"enable","archive-meta-option":["date","author","category"],"archive-show-read-more":"enable","woocommerce-archive-sidebar":"right","woocommerce-archive-sidebar-left":"gdlr-core-sidebar-preset","woocommerce-archive-sidebar-right":"shop","woocommerce-archive-column-size":"30","woocommerce-archive-thumbnail":"Portfolio Thumbnail Portrait","woocommerce-related-product-column-size":"15","woocommerce-related-product-num-fetch":"4","woocommerce-related-product-thumbnail":"Blog Column Thumbnail","portfolio-slug":"portfolio","portfolio-category-slug":"portfolio_category","portfolio-tag-slug":"portfolio_tag","enable-single-portfolio-navigation":"enable","enable-single-portfolio-navigation-in-same-tag":"enable","portfolio-icon-hover-link":"icon_link_alt","portfolio-icon-hover-video":"icon_film","portfolio-icon-hover-image":"icon_zoom-in_alt","portfolio-icon-hover-size":"22px","enable-related-portfolio":"enable","related-portfolio-style":"grid","related-portfolio-column-size":"20","related-portfolio-num-fetch":"3","related-portfolio-thumbnail-size":"Portfolio Thumbnail","related-portfolio-num-excerpt":"20","archive-portfolio-sidebar":"none","archive-portfolio-sidebar-left":"gdlr-core-sidebar-preset","archive-portfolio-sidebar-right":"gdlr-core-sidebar-preset","archive-portfolio-style":"medium","archive-portfolio-thumbnail-size":"full","archive-portfolio-grid-text-align":"left","archive-portfolio-grid-style":"normal","archive-enable-portfolio-tag":"enable","archive-portfolio-medium-size":"small","archive-portfolio-medium-style":"switch","archive-portfolio-hover":"icon","archive-portfolio-column-size":"20","archive-portfolio-excerpt":"specify-number","archive-portfolio-excerpt-number":"55","personnel-slug":"personnel","personnel-category-slug":"personnel_category","fixed-footer":"disable","enable-footer":"enable","footer-top-padding":"70px","footer-bottom-padding":"50px","footer-style":"footer-2","enable-copyright":"enable","copyright-style":"left-right","copyright-top-padding":"30px","copyright-bottom-padding":"30px","copyright-font-letter-spacing":"0px","copyright-text-transform":"none","copyright-text":"","copyright-left":"","copyright-right":"Copyright 2017 GoodLayers, All Right Reserved","enable-back-to-top":"enable","related-portfolio-enable-tag":"disable","related-portfolio-thumbnail-hover":"title","related-portfolio-title-font-size":"15px","related-portfolio-title-font-weight":"500","boxed-layout-border-radius":"0px"},"seocrawler_typography":{"heading-font":"Poppins","navigation-font":"Nunito","content-font":"Poppins","info-font":"Poppins","blog-info-font":"Poppins","quote-font":"Droid Serif","additional-font":"Georgia, serif","additional-font2":"Georgia, serif","h1-font-size":"52px","h2-font-size":"48px","h3-font-size":"36px","h4-font-size":"28px","h5-font-size":"22px","h6-font-size":"18px","navigation-font-size":"14px","navigation-font-weight":"800","navigation-font-letter-spacing":"","navigation-text-transform":"uppercase","content-font-size":"16px","content-line-height":"1.7","testimonial-font":"Droid Serif"},"seocrawler_color":{"page-preload-background-color":"#ffffff","top-bar-background-color":"#ffffff","top-bar-bottom-border-color":"#ffffff","top-bar-text-color":"#ea4517","top-bar-link-color":"#ffffff","top-bar-link-hover-color":"#ffffff","top-bar-social-color":"#ea4517","top-bar-social-hover-color":"#000000","header-background-color":"#191919","header-plain-bottom-border-color":"#e8e8e8","navigation-bar-background-color":"#f4f4f4","navigation-bar-top-border-color":"#e8e8e8","navigation-slide-bar-color":"#ea4517","logo-background-color":"#ffffff","navigation-bar-right-icon-color":"#ffffff","woocommerce-cart-icon-number-background":"#ea4517","woocommerce-cart-icon-number-color":"#ffffff","secondary-menu-icon-color":"#ffffff","secondary-menu-border-color":"#dddddd","search-overlay-background-color":"#000000","top-cart-background-color":"#303030","top-cart-text-color":"#b5b5b5","top-cart-view-cart-color":"#ffffff","top-cart-checkout-color":"#ea4517","breadcrumbs-text-color":"#c0c0c0","breadcrumbs-text-active-color":"#777777","main-menu-text-color":"#ffffff","main-menu-text-hover-color":"#ffffff","sub-menu-background-color":"#f3f3f3","sub-menu-text-color":"#6d6d6d","sub-menu-text-hover-color":"#ea4517","sub-menu-text-hover-background-color":"#ffffff","sub-mega-menu-title-color":"#3f3f3f","sub-mega-menu-divider-color":"#e0e0e0","side-menu-text-color":"#979797","side-menu-text-hover-color":"#ffffff","side-menu-background-color":"#1f1f1f","side-menu-border-color":"#626262","overlay-menu-background-color":"#000000","overlay-menu-border-color":"#424242","overlay-menu-text-color":"#ffffff","overlay-menu-text-hover-color":"#a8a8a8","anchor-bullet-background-color":"#777777","anchor-bullet-background-active-color":"#ffffff","navigation-right-button-text-color":"#ffffff","navigation-right-button-background-color":"#ea4517","navigation-right-button-border-color":"#333333","navigation-right-button-text-hover-color":"#ea4517","navigation-right-button-background-hover-color":"#ffffff","navigation-right-button-border-hover-color":"#555555","body-background-color":"#ffffff","container-background-color":"#ffffff","page-title-color":"#ffffff","page-caption-color":"#ffffff","page-title-background-overlay-color":"#000000","body-content-color":"#6e6e6e","heading-color":"#383838","link-color":"#545454","link-hover-color":"#333333","divider-color":"#e6e6e6","input-box-background-color":"#f3f3f3","input-box-border-color":"#d7d7d7","input-box-text-color":"#7c7c7c","input-box-placeholder-color":"#7c7c7c","404-content-background-color":"#23618e","404-head-color":"#ffffff","404-title-color":"#ffffff","404-caption-color":"#c3e7ff","404-input-background-color":"#000000","404-input-text-color":"#ffffff","404-back-to-home-color":"#ffffff","sidebar-title-color":"#383838","sidebar-link-color":"#484848","sidebar-link-hover-color":"#323232","recent-post-widget-info-icon-color":"#9c9c9c","recent-post-widget-info-link-color":"#a0a0a0","post-slider-widget-title-color":"#ffffff","post-slider-widget-info-color":"#9c9c9c","search-box-text-color":"#b5b5b5","search-box-border-color":"#e0e0e0","search-box-icon-color":"#c7c7c7","twitter-widget-icon-color":"#303030","twitter-widget-date-color":"#b5b5b5","footer-background-color":"#202020","footer-title-color":"#ffffff","footer-content-color":"#ffffff","footer-link-color":"#ea4517","footer-link-hover-color":"#ffffff","footer-divider-color":"#303030","copyright-background-color":"#181818","copyright-text-color":"#838383","copyright-link-color":"#838383","copyright-link-hover-color":"#838383","back-to-top-background-color":"#dbdbdb","back-to-top-text-color":"#313131","single-blog-title-color":"#ffffff","single-blog-info-color":"#ffffff","single-blog-date-day-color":"#ffffff","single-blog-date-month-color":"#b1b1b1","single-blog-divider-color":"#ffffff","single-blog-title-background-overlay-color":"#000000","single-blog-author-title-color":"#464646","single-blog-author-caption-color":"#b1b1b1","single-blog-navigation-color":"#bcbcbc","single-blog-comment-title-color":"#464646","single-blog-comment-background-color":"#f9f9f9","single-blog-comment-reply-color":"#bcbcbc","single-blog-comment-time-color":"#b1b1b1","blog-title-color":"#343434","blog-title-hover-color":"#343434","blog-sticky-banner-color":"#444444","blog-sticky-banner-background":"#f3f3f3","blog-info-color":"#989898","blog-date-day-color":"#353535","blog-date-month-color":"#8a8a8a","blog-frame-background-color":"#ffffff","blog-modern-text-color":"#ffffff","blog-aside-background-color":"#ea4517","blog-aside-text-color":"#ffffff","pagination-background-color":"#e8e8e8","pagination-text-color":"#929292","pagination-background-hover-color":"#ea4517","pagination-text-hover-color":"#ffffff","pagination-plain-color":"#b4b4b4","pagination-plain-hover-color":"#424242","single-portfolio-nav-color":"#bcbcbc","portfolio-frame-background-color":"#ffffff","portfolio-title-color":"#3a3a3a","portfolio-info-head-color":"#343434","portfolio-info-color":"#b1b1b1","portfolio-badge-text-color":"#ffffff","portfolio-badge-background-color":"#ea4517","portfolio-thumbnail-title-color":"#ffffff","portfolio-thumbnail-info-color":"#cecece","portfolio-text-filter-color":"#aaaaaa","portfolio-text-filter-active-color":"#ea4517","portfolio-button-filter-text-color":"#838383","portfolio-button-filter-background-color":"#f1f1f1","portfolio-button-filter-text-active-color":"#ffffff","portfolio-button-filter-background-active-color":"#ea4517","price-table-background-color":"#f8f8f8","price-table-head-color":"#3e3e3e","price-table-head-top-gradient-color":"#525252","price-table-icon-color":"#ffffff","price-table-title-color":"#ffffff","price-table-caption-color":"#acacac","price-table-price-background-color":"#ebebeb","price-table-price-color":"#323232","price-table-price-suffix-color":"#acacac","price-table-price-button-color":"#ffffff","price-table-button-background-color":"#575757","price-table-button-background-top-gradient-color":"#414141","price-table-list-border-color":"#e5e5e5","price-table-active-head-color":"#ea4517","price-table-active-head-top-gradient-color":"#d62e00","price-table-active-icon-color":"#ffffff","price-table-active-title-color":"#ffffff","price-table-active-caption-color":"#ffdcd1","price-table-active-price-background-color":"#ffffff","price-table-active-price-color":"#323232","price-table-active-price-suffix-color":"#acacac","price-table-active-price-button-color":"#ffffff","price-table-active-button-background-color":"#ea4517","price-table-active-button-background-top-gradient-color":"#ea7352","accordion-normal-icon-color":"#191919","accordion-normal-title-head-color":"#191919","accordion-normal-title-color":"#191919","accordion-normal-icon-background-color":"#f3f3f3","accordion-icon-color":"#191919","accordion-title-head-color":"#191919","accordion-title-color":"#191919","accordion-title-background-color":"#f3f3f3","accordion-icon-active-color":"#191919","accordion-title-active-color":"#191919","accordion-title-background-active-color":"#f3f3f3","audio-background-color":"#e7e7e7","audio-text-color":"#202020","audio-content-background-color":"#afafaf","audio-content-progress-color":"#ea4517","audio-volume-background-color":"#afafaf","audio-volume-progress-color":"#646464","alert-box-item-background-color":"#ef5e68","alert-box-item-border-color":"#cd515a","alert-box-item-content-color":"#ffffff","alert-box-item-title-color":"#ffffff","blockquote-text-color":"#777777","blockquote-background-color":"#f5f5f5","blockquote-border-color":"#e2e2e2","blockquote-item-icon-color":"#4e4e4e","blockquote-item-content-color":"#4e4e4e","button-text-color":"#ffffff","button-text-hover-color":"#ffffff","button-background-color":"#ea4517","button-background-hover-color":"#2F2F2F","button-border-color":"#383838","button-border-hover-color":"#000000","button-gradient-background-color":"#ea4517","button-top-gradient-background-color":"#ea7656","call-to-action-title-color":"#2c2c2c","call-to-action-caption-color":"#535353","counter-item-top-text-color":"#828282","counter-item-top-icon-color":"#393939","counter-item-number-color":"#393939","counter-item-divider-color":"#393939","counter-item-bottom-text-color":"#393939","column-service-icon-color":"#9d9d9d","column-service-icon-background":"#f3f3f3","column-service-title-color":"#383838","column-service-caption-color":"#747474","dropdown-tab-head-background":"#ea4517","dropdown-tab-head-text":"#252525","flipbox-background-color":"#2d9bea","flipbox-border-color":"#2a80be","flipbox-icon-color":"#ffffff","flipbox-title-color":"#ffffff","flipbox-caption-color":"#ffffff","flipbox-content-color":"#ffffff","gallery-overlay-title":"#ffffff","gallery-overlay-caption":"#cecece","image-overlay-background-color":"#000000","image-overlay-icon-color":"#ffffff","image-overlay-icon-background":"#ffffff","image-item-border-color":"#000000","item-title-color":"#343434","item-title-caption-color":"#747474","item-title-link-color":"#747474","icon-list-item-icon-color":"#222222","icon-list-item-icon-background-color":"#f3f3f3","opening-hour-day-color":"#a5a5a5","opening-hour-open-color":"#262626","opening-hour-close-color":"#c8c8c8","opening-hour-icon-color":"#8a8989","opening-hour-divider-color":"#a6a6a6","personnel-grid-title-color":"#383838","personnel-grid-position-color":"#888888","personnel-grid-divider-color":"#cecece","personnel-grid-frame-color":"#f9f9f9","personnel-modern-title-color":"#ffffff","personnel-modern-position-color":"#ffffff","promo-box-item-title-color":"#383838","promo-box-content-border-color":"#e8e7e7","post-slider-title-color":"#ffffff","post-slider-info-color":"#c5c5c5","skill-bar-title-color":"#505050","skill-bar-icon-color":"#616161","skill-bar-background-color":"#f3f3f3","skill-bar-progress-color":"#ea4517","slider-outer-navigation-color":"#a7a7a7","slider-outer-navigation-background-color":"#f1f1f1","slider-control-navigation-color":"#8a8a8a","social-share-icon-color":"#202020","social-share-divider-color":"#e5e5e5","social-share-text-color":"#202020","stunning-text-title-color":"#747474","stunning-text-caption-color":"#383838","tab-title-color":"#8d8d8d","tab-title-background-color":"#f7f7f7","tab-title-border-color":"#ebebeb","tab-title-hover-bar-color":"#ea4517","tab-title-active-color":"#464646","tab-title-active-background-color":"#ffffff","table-head-background-color":"#ea4517","table-head-text-color":"#ffffff","table-odd-background-color":"#f9f9f9","table-odd-text-color":"#949494","table-even-background":"#f3f3f3","table-even-text":"#949494","testimonial-title-color":"#232323","testimonial-content-color":"#707070","testimonial-author-color":"#3b3b3b","testimonial-rating-color":"#ffa127","testimonial-position-color":"#3b3b3b","testimonial-quote-color":"#282828","title-item-title-color":"#383838","title-item-caption-color":"#747474","woocommerce-theme-color":"#ea4517","woocommerce-price-color":"#ea4517","woocommerce-price-linethrough-color":"#949494","woocommerce-button-background-hover-color":"#ea4517","woocommerce-button-text-color":"#ffffff","woocommerce-button-text-hover-color":"#ffffff","woocommerce-input-background-color":"#f3f3f3","product-item-title-color":"#191919","product-item-title-hover-color":"#434343","view-detail-text-color":"#ffffff","view-detail-background-color":"#000000","add-to-cart-text-color":"#ffffff","add-to-cart-background-color":"#ea4517","widget-price-filter-bar-background-color":"#e6e6e6","widget-price-filter-range-color":"#9e3200","widget-price-filter-handle-color":"#ea4517","skin":[{"name":"Dark","title":"#ffffff","title-hover":"","caption":"#d3d3d3","content":"#d6d6d6","icon":"#e5e5e5","link":"#ffffff","link-hover":"#bfbfbf","divider":"#a3a3a3","border":"#a0a0a0","element-background":"#000000","element-content":"#e5e5e5","button-text":"","button-text-hover":"","button-background":"#212121","button-background-hover":"","button-border-color":"","button-border-hover-color":""},{"name":"Dark Port","title":"#ffffff","title-hover":"","caption":"#ffffff","content":"#ffffff","icon":"#ffffff","link":"","link-hover":"","divider":"","border":"","element-background":"#ffffff","element-content":"#ffffff","button-text":"","button-text-hover":"","button-background":"#212121","button-background-hover":"#212121","button-border-color":"","button-border-hover-color":""},{"name":"Purple","title":"","title-hover":"","caption":"","content":"#abb1ff","icon":"","link":"","link-hover":"","divider":"","border":"","element-background":"","element-content":"","button-text":"","button-text-hover":"","button-background":"","button-background-hover":"","button-border-color":"","button-border-hover-color":""},{"name":"Red Dark","title":"","title-hover":"","caption":"","content":"#d0888b","icon":"","link":"","link-hover":"","divider":"","border":"","element-background":"","element-content":"","button-text":"","button-text-hover":"","button-background":"","button-background-hover":"","button-border-color":"","button-border-hover-color":""},{"name":"Port Carousel","title":"","title-hover":"","caption":"","content":"","icon":"#6d6d6d","link":"","link-hover":"","divider":"","border":"","element-background":"","element-content":"","button-text":"","button-text-hover":"","button-background":"","button-background-hover":"","button-border-color":"","button-border-hover-color":""},{"name":"About Orange","title":"#ffffff","title-hover":"","caption":"#ffffff","content":"#ff4800","icon":"","link":"","link-hover":"","divider":"","border":"","element-background":"","element-content":"","button-text":"","button-text-hover":"","button-background":"","button-background-hover":"","button-border-color":"","button-border-hover-color":""},{"name":"Contact form white","title":"","title-hover":"","caption":"","content":"","icon":"","link":"","link-hover":"","divider":"","border":"","element-background":"#ffffff","element-content":"","button-text":"","button-text-hover":"","button-background":"","button-background-hover":"","button-border-color":"","button-border-hover-color":""},{"name":"Contact form grey","title":"","title-hover":"","caption":"","content":"","icon":"","link":"","link-hover":"","divider":"","border":"","element-background":"#ffffff","element-content":"#7f7f7f","button-text":"","button-text-hover":"","button-background":"#81ca41","button-background-hover":"","button-border-color":"","button-border-hover-color":""},{"name":"Purple Counter","title":"#ffffff","title-hover":"","caption":"#9bb6f3","content":"#9bb6f3","icon":"#ffffff","link":"","link-hover":"","divider":"","border":"","element-background":"","element-content":"","button-text":"","button-text-hover":"","button-background":"","button-background-hover":"","button-border-color":"","button-border-hover-color":""},{"name":"CTA Purple","title":"#ffffff","title-hover":"","caption":"#aac1f6","content":"#aac1f6","icon":"","link":"","link-hover":"","divider":"","border":"","element-background":"","element-content":"","button-text":"#ffffff","button-text-hover":"","button-background":"#81ca41","button-background-hover":"","button-border-color":"","button-border-hover-color":""},{"name":"CTA HP3","title":"#ffffff","title-hover":"","caption":"#ffffff","content":"#ffffff","icon":"","link":"","link-hover":"","divider":"","border":"","element-background":"","element-content":"","button-text":"","button-text-hover":"","button-background":"#43a351","button-background-hover":"","button-border-color":"","button-border-hover-color":""},{"name":"HP3 Service","title":"#ffffff","title-hover":"","caption":"#c9fed1","content":"#c9fed1","icon":"","link":"","link-hover":"","divider":"","border":"","element-background":"","element-content":"","button-text":"#383838","button-text-hover":"#383838","button-background":"#ffffff","button-background-hover":"","button-border-color":"","button-border-hover-color":""},{"name":"Contact form green","title":"#ffffff","title-hover":"","caption":"","content":"","icon":"","link":"","link-hover":"","divider":"","border":"","element-background":"#ffffff","element-content":"#b7b7b7","button-text":"#ffffff","button-text-hover":"","button-background":"#2c2c2c","button-background-hover":"#43a351","button-border-color":"","button-border-hover-color":""},{"name":"Landing Plugin","title":"","title-hover":"","caption":"","content":"#b9d2ff","icon":"","link":"","link-hover":"","divider":"","border":"","element-background":"","element-content":"","button-text":"","button-text-hover":"","button-background":"","button-background-hover":"","button-border-color":"","button-border-hover-color":""}],"sub-mega-menu-content-color":"#999999"},"seocrawler_plugin":{"enable-srcset":"enable","lightbox":"ilightbox","ilightbox-skin":"dark","link-to-lightbox":"enable","additional-css":"","additional-mobile-css":"","additional-head-script":"","additional-script":"","enable-maintenance":"disable","maintenance-page":"2","enable-preload":"disable","preload-image":"","thumbnail-sizing":[{"name":"Personnel Thumbnail","width":"700","height":"500","hard-crop":""},{"name":"Portfolio Thumbnail","width":"700","height":"450","hard-crop":""},{"name":"Portfolio Thumbnail Portrait","width":"700","height":"660","hard-crop":""},{"name":"Portfolio Thumbnail Portrait 2","width":"600","height":"800","hard-crop":""},{"name":"Large Landscape ","width":"1550","height":"700","hard-crop":""},{"name":"Portfolio Side Description Large","width":"900","height":"500","hard-crop":""},{"name":"Blog Full Thumbnail","width":"1100","height":"490","hard-crop":""},{"name":"Blog Column Thumbnail","width":"700","height":"430","hard-crop":""},{"name":"Personnel Square","width":"600","height":"600","hard-crop":""},{"name":"Personnel Thumbnail","width":"500","height":"655","hard-crop":""}]}}';
			$default_theme_option = json_decode($default_theme_option, true);
			foreach( $default_theme_option as $option_slug => $option_value ){
				$option = get_option($option_slug, array());
				if( empty($option) ){
					update_option($option_slug, $option_value);
				}
			}

			// redirect to plugin installation
			$plugin_slug = 'goodlayers-core';
			$getting_start_url = 'admin.php?page=gdlr_core_getting_start';
			// $redirect_url = seocrawler_tgmpa_is_plugin_active($plugin_slug,  $getting_start_url);
			$redirect_url = seocrawler_tgmpa_auto_install_url($plugin_slug,  $getting_start_url);
			
			if( empty($redirect_url) ){
				wp_redirect(admin_url('themes.php?page=tgmpa-install-plugins'));
			}else{
				wp_redirect($redirect_url);
			}

		}
	}